<?php
namespace Mainto\Bridge\Invokes\WorkOrder\WorkOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateCmd $params)
 * @method countByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method detailByParams(array $params)
 * @method reporterCountByParams(array $params)
 * @method notFinishedCountByParams(array $params)
 * @method bugCountByParams(array $params)
 * @method codingInfoByParams(array $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\ListCmd $params)
 * @method locationToCodingByParams(array $params)
 * @method locationToDingChatByParams(array $params)
 * @method hookInteractiveCardByParams(array $params)
 * @method categoriesCountByParams(array $params)
 * @method categoriesCountByDateByParams(array $params)
 * @method getAllowRelationCodingByParams(array $params)
 * @method createByAdminByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $params)
 * @method deleteByParams(array $params)
 * @method processByParams(array $params)
 * @method finishByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\FinishCmd $params)
 * @method updateCategoryByParams(array $params)
 * @method createCodingByParams(array $params)
 * @method bindCodingByParams(array $params)
 * @method resetDeletedCodingByParams(array $params)
 * @method removeCodingRelationByParams(array $params)
 */
class WorkOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * count
     *
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * detail
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function detail (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * reporterCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function reporterCount () {
        return self::getClass()->reporterCount();
    }

    /**
     * notFinishedCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function notFinishedCount () {
        return self::getClass()->notFinishedCount();
    }

    /**
     * bugCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function bugCount () {
        return self::getClass()->bugCount();
    }

    /**
     * codingInfo
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO
     */
    public static function codingInfo (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->codingInfo([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO"
        );
    }

    /**
     * list
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\ListCmd $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\ListCmd $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\ListDTO"
        );
    }


    /**
     * locationToCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function locationToCoding ($context, int $workOrderId) {
        return self::getClass()->locationToCoding([
            "context" => $context,
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * 跳转到钉钉伙伴
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function locationToDingChat ($context, int $workOrderId) {
        return self::getClass()->locationToDingChat([
            "context" => $context,
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * hookInteractiveCard
     *
     * @throws  \Exception
     * @return  string
     */
    public static function hookInteractiveCard ($context) {
        return self::getClass()->hookInteractiveCard();
    }

    /**
     * categoriesCount
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\RpcServer\Util\Types\Map<\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountDTO>
     */
    public static function categoriesCount ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->categoriesCount([
                            "context" => $context,
                        ]),
            "\Mainto\RpcServer\Util\Types\Map<\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountDTO>"
        );
    }

    /**
     * categoriesCountByDate
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountByDateDTO[]
     */
    public static function categoriesCountByDate ($context) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->categoriesCountByDate([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountByDateDTO[]"
        );
    }

    /**
     * getAllowRelationCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $codingId codingId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO
     */
    public static function getAllowRelationCoding (int $workOrderId, int $codingId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllowRelationCoding([
                            "workOrderId" => $workOrderId,
                            "codingId" => $codingId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO"
        );
    }

    /**
     * createByAdmin
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $command
     * @throws  \Exception
     * @return  int
     */
    public static function createByAdmin (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $command) {
        return self::getClass()->createByAdmin($command);
    }


    /**
     * delete
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $workOrderId, int $operator) {
        return self::getClass()->delete([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * process
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function process (int $workOrderId, int $operator) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->process([
                            "workOrderId" => $workOrderId,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * finish
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\FinishCmd $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function finish (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\FinishCmd $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->finish($command),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }


    /**
     * updateCategory
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  string $category 分类 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function updateCategory (int $workOrderId, string $category, int $operator) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateCategory([
                            "workOrderId" => $workOrderId,
                            "category" => $category,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * createCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function createCoding ($context, int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createCoding([
                            "context" => $context,
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * bindCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $codingId codingId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function bindCoding (int $workOrderId, int $codingId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindCoding([
                            "workOrderId" => $workOrderId,
                            "codingId" => $codingId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * resetDeletedCoding
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetDeletedCoding ($context) {
        return self::getClass()->resetDeletedCoding([
            "context" => $context,
        ]);
    }

    /**
     * removeCodingRelation
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function removeCodingRelation (int $workOrderId, int $operator) {
        return self::getClass()->removeCodingRelation([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('WorkOrder', 'WorkOrder\WorkOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('WorkOrder', 'WorkOrder\WorkOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}