<?php
namespace Mainto\Bridge\Invokes\WorkOrder\WorkOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByAdminByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $params)
 * @method deleteByParams(array $params)
 */
class Manage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createByAdmin
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $command
     * @throws  \Exception
     * @return  int
     */
    public static function createByAdmin (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $command) {
        return self::getClass()->createByAdmin($command);
    }


    /**
     * delete
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $workOrderId, int $operator) {
        return self::getClass()->delete([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('WorkOrder', 'WorkOrder\Manage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('WorkOrder', 'WorkOrder\Manage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}