<?php
namespace Mainto\Bridge\Invokes\WorkOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getConnectSignatureByParams(array $params)
 * @method connectByParams(array $params)
 */
class WorkOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  Create\CreateDto $dto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (Create\CreateDto $dto) {
        return self::getClass()->create($dto);
    }

    /**
     * getConnectSignature
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getConnectSignature () {
        return self::getClass()->getConnectSignature();
    }

    /**
     * connect
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function connect () {
        return self::getClass()->connect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('WorkOrder', 'WorkOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('WorkOrder', 'WorkOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}