<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-17 17:57:53
 */
namespace Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd;

class CreateByAppCmd {
    /**
     * @var  int
     * 当前登录账号Id
     * validation: 
     */
    public int $currentStaffId;
    /**
     * @var  int
     * 当前登录选择的门店
     * validation: 
     */
    public int $currentStoreId = 0;
    /**
     * @var  string
     * 咨询内容
     * validation: contentLength
     */
    public string $content;
    /**
     * @var  array
     * 附件
     * validation: 
     */
    public array $appendix = [];
    /**
     * @var  int
     * 问题分类(默认0)
     * validation: exclude_if:categoryId,=,0|exists:work_order_categories,id
     */
    public int $categoryId = 0;
    /**
     * @var  string
     * 反馈来源域名 location.host
     * validation: max:128|origin
     */
    public string $origin;
    /**
     * @var  string
     * 反馈来源中文描述
     * validation: 
     */
    public string $referText;
    /**
     * @var  null|string
     * 
     * validation: 
     */
    public ?string $clientIP;
    /**
     * @var  null|string
     * 
     * validation: 
     */
    public ?string $orderNo = null;

    public function __construct (int $currentStaffId, string $content, string $origin, string $referText, ?string $clientIP) {
        $this->currentStaffId = $currentStaffId;
        $this->content = $content;
        $this->origin = $origin;
        $this->referText = $referText;
        $this->clientIP = $clientIP;
    }

    public static function create(int $currentStaffId, string $content, string $origin, string $referText, ?string $clientIP): self {
        return new self($currentStaffId, $content, $origin, $referText, $clientIP);
    }

    public function setCurrentStaffId(int $currentStaffId): self {
        $this->currentStaffId = $currentStaffId;

        return $this;
    }

    public function setCurrentStoreId(int $currentStoreId): self {
        $this->currentStoreId = $currentStoreId;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setAppendix(array $appendix): self {
        $this->appendix = $appendix;

        return $this;
    }

    public function setCategoryId(int $categoryId): self {
        $this->categoryId = $categoryId;

        return $this;
    }

    public function setOrigin(string $origin): self {
        $this->origin = $origin;

        return $this;
    }

    public function setReferText(string $referText): self {
        $this->referText = $referText;

        return $this;
    }

    public function setClientIP(?string $clientIP): self {
        $this->clientIP = $clientIP;

        return $this;
    }

    public function setOrderNo(?string $orderNo): self {
        $this->orderNo = $orderNo;

        return $this;
    }
}