<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getUserAddressesByParams(array $params)
 */
class UserAddress {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加用户地址.迁移为ddd
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  string $name 用户姓名 [ require true ]
     * @support  string $phone 手机号 [ require false ]
     * @support  int $cityId 城市ID [ require true ]
     * @support  int $provinceId 省ID [ require true ]
     * @support  int $districtId 区ID [ require true ]
     * @support  string $addressDetail 地址详情 [ require false ]
     * @support  bool $isDefaultAddress 是否是默认地址 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function add (int $userId) {
        return self::getClass()->add([
            "userId" => $userId,
        ]);
    }

    /**
     * 更新用户地址.迁移为ddd
     *
     * @param  int $id 地址ID [ require true ]
     * @support  string $name 用户姓名 [ require false ]
     * @support  string $phone 手机号 [ require false ]
     * @support  int $cityId 城市ID [ require false ]
     * @support  int $provinceId 省ID [ require false ]
     * @support  int $districtId 区ID [ require false ]
     * @support  string $addressDetail 地址详情 [ require false ]
     * @support  bool $isDefaultAddress 是否是默认地址 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除用户地址.迁移为ddd
     *
     * @param  int $id 地址ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取用户地址列表.迁移为ddd
     *
     * @support  int $userId 用户ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserAddresses () {
        return self::getClass()->getUserAddresses([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'User\UserAddress');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'User\UserAddress');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}