<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setUserTagByParams(array $params)
 * @method editUserTagByParams(array $params)
 * @method deleteUserTagByParams(array $params)
 * @method getUserTagListByParams(array $params)
 */
class UserTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置userTag
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $tagName 标记名称 [ require true ]
     * @param  string $tagContent 标记内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setUserTag (int $userId, string $tagName, string $tagContent) {
        return self::getClass()->setUserTag([
            "userId" => $userId,
            "tagName" => $tagName,
            "tagContent" => $tagContent,
        ]);
    }

    /**
     * 修改userTag
     *
     * @param  int $tagId tagId [ require true ]
     * @param  int $userId 用户uid [ require false ]
     * @param  string $tagName tag名称 [ require false ]
     * @param  string $tagContent tag内容 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editUserTag (int $tagId, int $userId = 0, string $tagName = '', string $tagContent = '') {
        return self::getClass()->editUserTag([
            "tagId" => $tagId,
            "userId" => $userId,
            "tagName" => $tagName,
            "tagContent" => $tagContent,
        ]);
    }

    /**
     * 删除userTag
     *
     * @param  int $tagId 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteUserTag (int $tagId) {
        return self::getClass()->deleteUserTag([
            "tagId" => $tagId,
        ]);
    }

    /**
     * userTag列表查询
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  array $userIds 用户IDs [ require true ]
     * @param  string $tagName tag标签 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页面大小 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserTag\UserTagListDTO
     */
    public static function getUserTagList (int $userId, array $userIds, string $tagName = '', int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserTagList([
                            "userId" => $userId,
                            "userIds" => $userIds,
                            "tagName" => $tagName,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserTag\UserTagListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\UserTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\UserTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}