<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addInvoiceTitleByParams(array|\Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\AddInvoiceTitleCmd $params)
 * @method updateInvoiceTitleByParams(array|\Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\SaveInvoiceTitleCmd $params)
 * @method deleteInvoiceTitleByParams(array $params)
 * @method invoiceTitleInfoByParams(array $params)
 * @method invoiceTitleListByParams(array|\Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\InvoiceTitleListCmd $params)
 * @method setIsDefaultByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加抬头
     *
     * @var  \Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\AddInvoiceTitleCmd $addInvoiceTitleCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addInvoiceTitle (\Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\AddInvoiceTitleCmd $addInvoiceTitleCmd) {
        return self::getClass()->addInvoiceTitle($addInvoiceTitleCmd);
    }


    /**
     * 修改抬头
     *
     * @var  \Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\SaveInvoiceTitleCmd $saveInvoiceTitleCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateInvoiceTitle (\Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\SaveInvoiceTitleCmd $saveInvoiceTitleCmd) {
        return self::getClass()->updateInvoiceTitle($saveInvoiceTitleCmd);
    }


    /**
     * 删除发票抬头
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteInvoiceTitle (int $invoiceTitleId) {
        return self::getClass()->deleteInvoiceTitle([
            "invoiceTitleId" => $invoiceTitleId,
        ]);
    }

    /**
     * 发票抬头详情
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\InvoiceTitle\InvoiceTitleDTO
     */
    public static function invoiceTitleInfo (int $invoiceTitleId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->invoiceTitleInfo([
                            "invoiceTitleId" => $invoiceTitleId,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\InvoiceTitle\InvoiceTitleDTO"
        );
    }

    /**
     * 用户发票抬头列表
     *
     * @var  \Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\InvoiceTitleListCmd $invoiceTitleListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\InvoiceTitle\InvoiceTitleListDTO
     */
    public static function invoiceTitleList (\Mainto\Bridge\Structs\User\Rpc\Cmd\InvoiceTitle\InvoiceTitleListCmd $invoiceTitleListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->invoiceTitleList($invoiceTitleListCmd),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\InvoiceTitle\InvoiceTitleListDTO"
        );
    }


    /**
     * 设置为默认发票抬头
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setIsDefault (int $invoiceTitleId) {
        return self::getClass()->setIsDefault([
            "invoiceTitleId" => $invoiceTitleId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}