<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addNormalAddressByParams(array $params)
 * @method updateSubscribeUserIdByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置用户家庭地址
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $name 名称 [ require false ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $detail 地址详情 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addNormalAddress (int $userId, string $phone, string $detail, string $name = '') {
        return self::getClass()->addNormalAddress([
            "userId" => $userId,
            "phone" => $phone,
            "detail" => $detail,
            "name" => $name,
        ]);
    }

    /**
     * 更新subscribe的userId的值
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $unionId unionId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSubscribeUserId (int $userId, string $unionId) {
        return self::getClass()->updateSubscribeUserId([
            "userId" => $userId,
            "unionId" => $unionId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}