<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-26 11:58:20
 */
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class UserTag
 * @method setUserTagByParams(array $params) 设置伙伴标记.迁移为ddd
 * @method queryUserTagByParams(array $params) 根据uid|tagname 查询tag
 * @method getUserTagDataByParams(array $params) 标签查询.迁移为ddd
 * @method editUserTagByParams(array $params) 修改tag表.迁移为ddd
 * @method delUserTagByParams(array $params) 删除用户tag.迁移为ddd
 */
class UserTag {
    private static string $serviceName = "User";

    private static string $className = "User\\UserTag";

    /**
     * 设置伙伴标记.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function setUserTag (int $user_id, string $tag_name,  $tag_content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserTag(array_merge($_params, ["user_id" => $user_id, "tag_name" => $tag_name, "tag_content" => $tag_content]));
    }

    /**
     * 根据uid|tagname 查询tag
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function queryUserTag (int $userId, string $tagName = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryUserTag(["userId" => $userId, "tagName" => $tagName]);
    }

    /**
     * 标签查询.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUserTagData (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserTagData($_params);
    }

    /**
     * 修改tag表.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editUserTag (int $tagId, int $userId = 0, string $tagName = '', string $tagContent = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->editUserTag(["tagId" => $tagId, "userId" => $userId, "tagName" => $tagName, "tagContent" => $tagContent]);
    }

    /**
     * 删除用户tag.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delUserTag (int $tagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delUserTag(["tagId" => $tagId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}