<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-26 11:58:20
 */
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class User
 * @method addUserByParams(array $params) 注册用户.迁移为ddd
 * @method addNewUserByParams(array $params) 注册用户-作废
 * @method registerUserSmsCodeByParams(array $params) 通过短信验证码注册用户
 * @method getUserIdByParams(array $params) 通过手机号查询userid.迁移为ddd
 * @method addUserInfoByParams(array $params) 新增一条用户数据.迁移为ddd
 * @method addNewUserForAuthLoginByParams(array $params) 认证注册添加用户.迁移为ddd
 * @method changeUserPhoneByParams(array $params) 修改用户手机号
 * @method changeUserInfoByParams(array $params) 修改用户相关信息-作废
 * @method editUserByParams(array $params) 编辑用户相关信息.迁移为ddd
 * @method changeUserUnionIdByParams(array $params) 更改用户union id.迁移为ddd
 * @method checkUserPasswordByParams(array $params) 核对用户密码.迁移为ddd
 * @method checkUserExistByParams(array $params) 判断用户是否存在.迁移为ddd
 * @method changUserPasswordByParams(array $params) 用户修改密码.迁移为ddd
 * @method changeUserPasswordDirectByParams(array $params) 直接修改用户密码(不进行旧密码验证)
 * @method changeUserPasswordDirectByMobileByParams(array $params) (海马体对接)忘记密码
 * @method useUserIdGetUserInfoByParams(array $params) 通过用户id获取用户的信息 [废弃]
 * @method getUserByIdsByParams(array $params) 通过用户ids获取用户信息
 * @method getUserInviteByParams(array $params) 获取我的邀请人数.迁移为ddd
 * @method queryUserByUnionIdByParams(array $params) 根据unionId查询用户
 * @method forgetUserPasswordByParams(array $params) 忘记用户密码.迁移为ddd
 * @method getUserDataByParams(array $params) 查找相关联的用户.迁移为ddd
 * @method syncWechatUserInfoByParams(array $params) 登录时更新用户信息
 * @method getUserListByParams(array $params) 获取用户列表.迁移为ddd
 * @method logoutAndChangeUserPhoneByParams(array $params) 注销并修改用户手机号.迁移为ddd
 * @method saveInviterByParams(array $params) 修改用户邀请信息.迁移为ddd
 * @method getUserInviteNumByParams(array $params) 获取用户邀请数量.迁移为ddd
 * @method deleteUsersByParams(array $params) 删除用户信息.迁移为ddd
 * @method checkUserPhoneByIdByParams(array $params) 检测用户手机号是否符合规则
 * @method getUserListByPageByParams(array $params) 获取分页的用户列表数据，无搜索条件
 */
class User {
    private static string $serviceName = "User";

    private static string $className = "User\\User";

    /**
     * 注册用户.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addUser (string $phone, string $password, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addUser(array_merge($_params, ["phone" => $phone, "password" => $password]));
    }

    /**
     * 注册用户-作废
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addNewUser (string $phone, string $password, string $unionId = '', string $headImg = '', string $sex = null, string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->addNewUser(["phone" => $phone, "password" => $password, "unionId" => $unionId, "headImg" => $headImg, "sex" => $sex, "name" => $name]);
    }

    /**
     * 通过短信验证码注册用户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function registerUserSmsCode (string $phone, string $captcha, string $password, string $sex = null, string $headImg = '', string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->registerUserSmsCode(["phone" => $phone, "captcha" => $captcha, "password" => $password, "sex" => $sex, "headImg" => $headImg, "name" => $name]);
    }

    /**
     * 通过手机号查询userid.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function getUserId (string $phone, bool $noExistAddNew = true, bool $checkFirstLogin = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserId(["phone" => $phone, "noExistAddNew" => $noExistAddNew, "checkFirstLogin" => $checkFirstLogin]);
    }

    /**
     * 新增一条用户数据.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addUserInfo (string $phone, string $password, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addUserInfo(array_merge($_params, ["phone" => $phone, "password" => $password]));
    }

    /**
     * 认证注册添加用户.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addNewUserForAuthLogin (string $phone, string $register) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addNewUserForAuthLogin(["phone" => $phone, "register" => $register]);
    }

    /**
     * 修改用户手机号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPhone(["newPhone" => $newPhone, "oldPhone" => $oldPhone, "code" => $code, "certificate" => $certificate]);
    }

    /**
     * 修改用户相关信息-作废
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function changeUserInfo (int $user_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserInfo(array_merge($_params, ["user_id" => $user_id]));
    }

    /**
     * 编辑用户相关信息.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function editUser (int $userId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editUser(array_merge($_params, ["userId" => $userId]));
    }

    /**
     * 更改用户union id.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeUserUnionId (string $union_id, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserUnionId(["union_id" => $union_id, "user_id" => $user_id]);
    }

    /**
     * 核对用户密码.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkUserPassword (string $phone, string $password) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserPassword(["phone" => $phone, "password" => $password]);
    }

    /**
     * 判断用户是否存在.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkUserExist (string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserExist(["phone" => $phone]);
    }

    /**
     * 用户修改密码.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changUserPassword (int $user_id, string $old_password, string $new_password) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changUserPassword(["user_id" => $user_id, "old_password" => $old_password, "new_password" => $new_password]);
    }

    /**
     * 直接修改用户密码(不进行旧密码验证)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeUserPasswordDirect (int $userId, string $password) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPasswordDirect(["userId" => $userId, "password" => $password]);
    }

    /**
     * (海马体对接)忘记密码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeUserPasswordDirectByMobile (int $phone, string $password) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPasswordDirectByMobile(["phone" => $phone, "password" => $password]);
    }

    /**
     * 通过用户id获取用户的信息 [废弃]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function useUserIdGetUserInfo (array $user_id = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useUserIdGetUserInfo(["user_id" => $user_id]);
    }

    /**
     * 通过用户ids获取用户信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getUserByIds (array $userIds, bool $withHidden = false, bool $withTags = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserByIds(["userIds" => $userIds, "withHidden" => $withHidden, "withTags" => $withTags]);
    }

    /**
     * 获取我的邀请人数.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function getUserInvite (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInvite(["user_id" => $user_id]);
    }

    /**
     * 根据unionId查询用户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function queryUserByUnionId (string $unionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryUserByUnionId(["unionId" => $unionId]);
    }

    /**
     * 忘记用户密码.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function forgetUserPassword (string $phone, string $captcha, string $password) {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "captcha" => $captcha, "password" => $password]);
    }

    /**
     * 查找相关联的用户.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUserData (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserData($_params);
    }

    /**
     * 登录时更新用户信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function syncWechatUserInfo (int $user_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncWechatUserInfo(array_merge($_params, ["user_id" => $user_id]));
    }

    /**
     * 获取用户列表.迁移为ddd
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUserList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserList($_params);
    }

    /**
     * 注销并修改用户手机号.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function logoutAndChangeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logoutAndChangeUserPhone(["newPhone" => $newPhone, "oldPhone" => $oldPhone, "code" => $code, "certificate" => $certificate]);
    }

    /**
     * 修改用户邀请信息.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function saveInviter (int $userId, int $inviterUserId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveInviter(["userId" => $userId, "inviterUserId" => $inviterUserId]);
    }

    /**
     * 获取用户邀请数量.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function getUserInviteNum (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInviteNum(["userId" => $userId]);
    }

    /**
     * 删除用户信息.迁移为ddd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function deleteUsers (array $userIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteUsers(["userIds" => $userIds]);
    }

    /**
     * 检测用户手机号是否符合规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkUserPhoneById (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserPhoneById(["userId" => $userId]);
    }

    /**
     * 获取分页的用户列表数据，无搜索条件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserListByPage (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserListByPage(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}