<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-26 11:58:21
 */
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Profession
 * @method getAllIndustriesByParams(array $params) 获取全部行业列表
 * @method getPositionsByParams(array $params) 获取职位列表
 * @method getPositionInfoByParams(array $params) 获取职位详情
 */
class Profession {
    private static string $serviceName = "User";

    private static string $className = "Rpc\\Profession";

    /**
     * 获取全部行业列表
     * @return  array
    */
    public static function getAllIndustries () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllIndustries(),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\Profession\IndustryDTO[]"
        );
    }

    /**
     * 获取职位列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPositions (int $industryId = 0) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPositions(["industryId" => $industryId]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionBaseDTO[]"
        );
    }

    /**
     * 获取职位详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionDTO
    */
    public static function getPositionInfo (int $positionId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPositionInfo(["positionId" => $positionId]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}