<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setUserTagByParams(array $params)
 * @method recordUserLoginNumByParams(array $params)
 * @method queryUserLoginNumByParams(array $params)
 * @method queryUserTagByParams(array $params)
 * @method getUserTagDataByParams(array $params)
 * @method editUserTagByParams(array $params)
 * @method delUserTagByParams(array $params)
 */
class UserTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置伙伴标记.迁移为ddd
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $tag_name 标记名称 [ require true ]
     * @support  mixed $tag_content 标记内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserTag (int $user_id, string $tag_name) {
        return self::getClass()->setUserTag([
            "user_id" => $user_id,
            "tag_name" => $tag_name,
        ]);
    }

    /**
     * 记录用户登录次数
     *
     * @param  int $userId 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recordUserLoginNum (int $userId) {
        return self::getClass()->recordUserLoginNum([
            "userId" => $userId,
        ]);
    }

    /**
     * 查询用户登录次数
     *
     * @param  int $userId 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryUserLoginNum (int $userId) {
        return self::getClass()->queryUserLoginNum([
            "userId" => $userId,
        ]);
    }

    /**
     * 根据uid|tagname 查询tag
     *
     * @param  int $userId 用户uid [ require true ]
     * @param  string $tagName tag标签 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryUserTag (int $userId, string $tagName = '') {
        return self::getClass()->queryUserTag([
            "userId" => $userId,
            "tagName" => $tagName,
        ]);
    }

    /**
     * 标签查询.迁移为ddd
     *
     * @support  int $userId 用户ID [ require false ]
     * @support  array $userIds 用户IDs [ require false ]
     * @support  string $tagName tag标签 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserTagData () {
        return self::getClass()->getUserTagData([
        ]);
    }

    /**
     * 修改tag表.迁移为ddd
     *
     * @param  int $tagId tagId [ require true ]
     * @param  int $userId 用户uid [ require false ]
     * @param  string $tagName tag名称 [ require false ]
     * @param  string $tagContent tag内容 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserTag (int $tagId, int $userId = 0, string $tagName = '', string $tagContent = '') {
        return self::getClass()->editUserTag([
            "tagId" => $tagId,
            "userId" => $userId,
            "tagName" => $tagName,
            "tagContent" => $tagContent,
        ]);
    }

    /**
     * 删除用户tag.迁移为ddd
     *
     * @param  int $tagId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delUserTag (int $tagId) {
        return self::getClass()->delUserTag([
            "tagId" => $tagId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'User\UserTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'User\UserTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}