<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveSubscribeByParams(array $params)
 * @method deleteByOpenIdAndBrandByParams(array $params)
 * @method getInfoByOpenIdByParams(array $params)
 * @method getSubscribeListByParams(array $params)
 */
class UserSubscribe {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 存储用户关注记录
     *
     * @param  string $openId open id [ require true ]
     * @param  string $unionId union id [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveSubscribe (string $openId, string $unionId, string $brand) {
        return self::getClass()->saveSubscribe([
            "openId" => $openId,
            "unionId" => $unionId,
            "brand" => $brand,
        ]);
    }

    /**
     * 取关公众号删除记录
     *
     * @param  string $openId openid [ require true ]
     * @param  string $brand 平台 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteByOpenIdAndBrand (string $openId, string $brand) {
        return self::getClass()->deleteByOpenIdAndBrand([
            "openId" => $openId,
            "brand" => $brand,
        ]);
    }

    /**
     * 通过openId获取关注详情, 可能多条只取第一条
     *
     * @param  string $openId openId, 从openid调整为openId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeDTO
     */
    public static function getInfoByOpenId (string $openId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInfoByOpenId([
                            "openId" => $openId,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeDTO"
        );
    }

    /**
     * 分页查询-关注列表
     *
     * @param  array $userIds 用户IDs [ require false ]
     * @param  array $openIds openIds [ require false ]
     * @param  array $unionIds unionIds [ require false ]
     * @param  string $brand 模块 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeListDTO
     */
    public static function getSubscribeList (array $userIds = [], array $openIds = [], array $unionIds = [], string $brand = '', int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSubscribeList([
                            "userIds" => $userIds,
                            "openIds" => $openIds,
                            "unionIds" => $unionIds,
                            "brand" => $brand,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\UserSubscribe');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\UserSubscribe');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}