<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-21 11:07:38
 */
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UserAddress
 */
class UserAddress {
    private static string $serviceName = "User";

    private static string $className = "Rpc\\UserAddress";

    /**
     * 添加用户地址
     * @return  bool
    */
    public static function addUserAddress (\Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\AddUserAddressCmd $addUserAddressCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addUserAddress($addUserAddressCmd);
    }
    /**
     * 更新用户地址
     * @return  bool
    */
    public static function updateUserAddress (\Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\UpdateUserAddressCmd $updateUserAddressCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserAddress($updateUserAddressCmd);
    }
    /**
     * 删除用户地址
     * @return  bool
    */
    public static function deleteUserAddress (int $addressId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteUserAddress(["addressId" => $addressId]);
    }
    /**
     * 获取用户地址列表
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserAddress\UserAddressListDTO
    */
    public static function getUserAddresses (int $userId, int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserAddresses(["userId" => $userId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserAddress\UserAddressListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}