<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-27 11:41:43
 */
namespace Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress;

class AddUserAddressCmd {
    /**
     * @var  int
     * 用户ID
     * validation: 
     */
    public int $userId;
    /**
     * @var  string
     * 用户姓名
     * validation: 
     */
    public string $name;
    /**
     * @var  string
     * 手机号
     * validation: required|regex:/^1[3456789]\d{9}$/
     */
    public string $phone;
    /**
     * @var  int
     * 城市ID
     * validation: 
     */
    public int $cityId;
    /**
     * @var  int
     * 省ID
     * validation: 
     */
    public int $provinceId;
    /**
     * @var  int
     * 区ID
     * validation: 
     */
    public int $districtId;
    /**
     * @var  string
     * 地址详情
     * validation: required|min:2|max:120
     */
    public string $addressDetail;
    /**
     * @var  bool
     * 是否是默认地址
     * validation: 
     */
    public bool $isDefaultAddress = false;

    public function __construct (int $userId = 0, string $name = '', string $phone = '', int $cityId = 0, int $provinceId = 0, int $districtId = 0, string $addressDetail = '') {
        if (!is_null($userId)) {
            $this->userId = $userId;
        }
        if (!is_null($name)) {
            $this->name = $name;
        }
        if (!is_null($phone)) {
            $this->phone = $phone;
        }
        if (!is_null($cityId)) {
            $this->cityId = $cityId;
        }
        if (!is_null($provinceId)) {
            $this->provinceId = $provinceId;
        }
        if (!is_null($districtId)) {
            $this->districtId = $districtId;
        }
        if (!is_null($addressDetail)) {
            $this->addressDetail = $addressDetail;
        }
    }

    public static function create(int $userId = 0, string $name = '', string $phone = '', int $cityId = 0, int $provinceId = 0, int $districtId = 0, string $addressDetail = ''): self {
        return new self($userId, $name, $phone, $cityId, $provinceId, $districtId, $addressDetail);
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setPhone(string $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setProvinceId(int $provinceId): self {
        $this->provinceId = $provinceId;

        return $this;
    }

    public function setDistrictId(int $districtId): self {
        $this->districtId = $districtId;

        return $this;
    }

    public function setAddressDetail(string $addressDetail): self {
        $this->addressDetail = $addressDetail;

        return $this;
    }

    public function setIsDefaultAddress(bool $isDefaultAddress): self {
        $this->isDefaultAddress = $isDefaultAddress;

        return $this;
    }
}