<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-25 16:41:37
 */
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UserTag
 */
class UserTag {
    private static string $serviceName = "User";

    private static string $className = "User\\UserTag";

    /**
     * 设置伙伴标记.迁移为ddd
     * @return  bool
    */
    public static function setUserTag (int $user_id, string $tag_name,  $tag_content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserTag(["user_id" => $user_id, "tag_name" => $tag_name, "tag_content" => $tag_content]);
    }
    /**
     * 根据uid|tagname 查询tag
     * @return  mixed
    */
    public static function queryUserTag (int $userId, string $tagName = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryUserTag(["userId" => $userId, "tagName" => $tagName]);
    }
    /**
     * 标签查询.迁移为ddd
     * @return  mixed
    */
    public static function getUserTagData (int $userId, array $userIds, string $tagName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserTagData(["userId" => $userId, "userIds" => $userIds, "tagName" => $tagName]);
    }
    /**
     * 修改tag表.迁移为ddd
     * @return  bool
    */
    public static function editUserTag (int $tagId, int $userId = 0, string $tagName = '', string $tagContent = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->editUserTag(["tagId" => $tagId, "userId" => $userId, "tagName" => $tagName, "tagContent" => $tagContent]);
    }
    /**
     * 删除用户tag.迁移为ddd
     * @return  bool
    */
    public static function delUserTag (int $tagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delUserTag(["tagId" => $tagId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}