<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-07 10:01:18
 */
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UserSubscribe
 */
class UserSubscribe {
    private static string $serviceName = "User";

    private static string $className = "Rpc\\UserSubscribe";

    /**
     * 存储用户关注记录
     * @return  bool
    */
    public static function saveSubscribe (string $openId, string $unionId, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveSubscribe(["openId" => $openId, "unionId" => $unionId, "brand" => $brand]);
    }
    /**
     * 取关公众号删除记录
     * @return  bool
    */
    public static function deleteByOpenIdAndBrand (string $openId, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteByOpenIdAndBrand(["openId" => $openId, "brand" => $brand]);
    }
    /**
     * 通过openId获取关注详情, 可能多条只取第一条
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeDTO
    */
    public static function getInfoByOpenId (string $openId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getInfoByOpenId(["openId" => $openId]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeDTO"
        );
    }
    /**
     * 分页查询-关注列表
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeListDTO
    */
    public static function getSubscribeList (array $userIds = [], array $openIds = [], array $unionIds = [], string $brand = '', int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSubscribeList(["userIds" => $userIds, "openIds" => $openIds, "unionIds" => $unionIds, "brand" => $brand, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserSubscribe\UserSubscribeListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}