<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-07 10:01:18
 */
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RegisterRecord
 */
class RegisterRecord {
    private static string $serviceName = "User";

    private static string $className = "Rpc\\RegisterRecord";

    /**
     * 通过用户ID获取注册记录
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\RegisterRecord\RegisterRecordDTO
    */
    public static function getRecordByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRecordByUserId(["userId" => $userId]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\RegisterRecord\RegisterRecordDTO"
        );
    }
    /**
     * 获取我的邀请人数
     * @return  int
    */
    public static function getUserInviteCountByUserId (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInviteCountByUserId(["userId" => $userId]);
    }
    /**
     * 修改用户邀请信息
     * @return  bool
    */
    public static function saveInviter (int $userId, int $inviterUserId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveInviter(["userId" => $userId, "inviterUserId" => $inviterUserId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}