<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-09 15:31:44
 */
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 */
class User {
    private static string $serviceName = "User";

    private static string $className = "Rpc\\User";

    /**
     * 新增用户
     */
    public static function addUser (\Mainto\Bridge\Structs\User\Rpc\Cmd\User\AddUserCmd $addUserCmd): \Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addUser($addUserCmd),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseDTO"
        );
    }
    /**
     * 编辑用户
     */
    public static function editUser (\Mainto\Bridge\Structs\User\Rpc\Cmd\User\EditUserCmd $editUserCmd): \Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editUser($editUserCmd),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseDTO"
        );
    }
    /**
     * 核对用户密码
     */
    public static function checkUserPassword (string $phone, string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserPassword(["phone" => $phone, "password" => $password, ]);
    }
    /**
     * 用户修改密码
     */
    public static function changeUserPassword (int $userId, string $newPassword, string $oldPassword = ''): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPassword(["userId" => $userId, "newPassword" => $newPassword, "oldPassword" => $oldPassword, ]);
    }
    /**
     * 用户忘记密码
     */
    public static function forgetUserPassword (string $phone, string $captcha, string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "captcha" => $captcha, "password" => $password, ]);
    }
    /**
     * 注销并修改用户手机号
     */
    public static function logoutAndChangeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->logoutAndChangeUserPhone(["newPhone" => $newPhone, "oldPhone" => $oldPhone, "code" => $code, "certificate" => $certificate, ]);
    }
    /**
     * 通过手机号查询用户基础信息, 不存在可以先添加再返回
     */
    public static function getUserBaseInfoByPhone (string $phone, bool $noExistAddNew = false): \Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBaseInfoByPhone(["phone" => $phone, "noExistAddNew" => $noExistAddNew, ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseDTO"
        );
    }
    /**
     * 查询基础用户信息
     */
    public static function getUserInfoByUserId (int $userId, bool $withTags = false): \Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseWithTagsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserInfoByUserId(["userId" => $userId, "withTags" => $withTags, ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseWithTagsDTO"
        );
    }
    /**
     * 查询用户信息, 包括地址，注册和tag信息
     */
    public static function getUserInfoByPhoneOrUserId (string $phone = '', int $userId = 0): \Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseWithDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserInfoByPhoneOrUserId(["phone" => $phone, "userId" => $userId, ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\User\UserBaseWithDTO"
        );
    }
    /**
     * 获取用户列表
     */
    public static function getUserList (?\Mainto\Bridge\Structs\User\Rpc\Cmd\User\UserListCmd $userListCmd = null): \Mainto\Bridge\Structs\User\Rpc\DTO\User\UserListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserList($userListCmd),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\User\UserListDTO"
        );
    }
    /**
     * 删除用户
     */
    public static function deleteUser (int $userId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteUser(["userId" => $userId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}