<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-01 15:54:13
 */
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 */
class User {
    private static string $serviceName = "User";

    private static string $className = "User\\User";

    /**
     * 注册用户.迁移为ddd
     *
     */
    public static function addUser (string $phone, string $password, string $sex, string $name, string $headImg, string $unionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addUser(["phone" => $phone, "password" => $password, "sex" => $sex, "name" => $name, "headImg" => $headImg, "unionId" => $unionId, ]);
    }
    /**
     * 注册用户-作废
     *
     */
    public static function addNewUser (string $phone, string $password, string $unionId = '', string $headImg = '', string $sex = null, string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->addNewUser(["phone" => $phone, "password" => $password, "unionId" => $unionId, "headImg" => $headImg, "sex" => $sex, "name" => $name, ]);
    }
    /**
     * 通过短信验证码注册用户
     *
     */
    public static function registerUserSmsCode (string $phone, string $captcha, string $password, string $sex = null, string $headImg = '', string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->registerUserSmsCode(["phone" => $phone, "captcha" => $captcha, "password" => $password, "sex" => $sex, "headImg" => $headImg, "name" => $name, ]);
    }
    /**
     * 通过手机号查询userid.迁移为ddd
     *
     */
    public static function getUserId (string $phone, bool $noExistAddNew = true, bool $checkFirstLogin = false): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserId(["phone" => $phone, "noExistAddNew" => $noExistAddNew, "checkFirstLogin" => $checkFirstLogin, ]);
    }
    /**
     * 新增一条用户数据.迁移为ddd
     *
     */
    public static function addUserInfo (string $password, string $name, string $phone, string $unionId, string $birth, string $headSculpture, string $address, string $sex, string $email, string $register) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addUserInfo(["password" => $password, "name" => $name, "phone" => $phone, "unionId" => $unionId, "birth" => $birth, "headSculpture" => $headSculpture, "address" => $address, "sex" => $sex, "email" => $email, "register" => $register, ]);
    }
    /**
     * 认证注册添加用户.迁移为ddd
     *
     */
    public static function addNewUserForAuthLogin (string $phone, string $register) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addNewUserForAuthLogin(["phone" => $phone, "register" => $register, ]);
    }
    /**
     * 修改用户手机号
     *
     */
    public static function changeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPhone(["newPhone" => $newPhone, "oldPhone" => $oldPhone, "code" => $code, "certificate" => $certificate, ]);
    }
    /**
     * 修改用户相关信息-作废
     *
     */
    public static function changeUserInfo (string $union_id, int $user_id, string $head_sculpture, string $name, string $birth, string $sex, string $address, string $email, int $position_id, int $city_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserInfo(["union_id" => $union_id, "user_id" => $user_id, "head_sculpture" => $head_sculpture, "name" => $name, "birth" => $birth, "sex" => $sex, "address" => $address, "email" => $email, "position_id" => $position_id, "city_id" => $city_id, ]);
    }
    /**
     * 编辑用户相关信息.迁移为ddd
     *
     */
    public static function editUser (string $unionId, int $userId, string $headSculpture, string $name, string $birth, string $sex, string $address, string $email, int $positionId, int $cityId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->editUser(["unionId" => $unionId, "userId" => $userId, "headSculpture" => $headSculpture, "name" => $name, "birth" => $birth, "sex" => $sex, "address" => $address, "email" => $email, "positionId" => $positionId, "cityId" => $cityId, ]);
    }
    /**
     * 更改用户union id.迁移为ddd
     *
     */
    public static function changeUserUnionId (string $union_id, int $user_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserUnionId(["union_id" => $union_id, "user_id" => $user_id, ]);
    }
    /**
     * 核对用户密码.迁移为ddd
     *
     */
    public static function checkUserPassword (string $phone, string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserPassword(["phone" => $phone, "password" => $password, ]);
    }
    /**
     * 判断用户是否存在.迁移为ddd
     *
     */
    public static function checkUserExist (string $phone): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserExist(["phone" => $phone, ]);
    }
    /**
     * 用户修改密码.迁移为ddd
     *
     */
    public static function changUserPassword (int $user_id, string $old_password, string $new_password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changUserPassword(["user_id" => $user_id, "old_password" => $old_password, "new_password" => $new_password, ]);
    }
    /**
     * 直接修改用户密码(不进行旧密码验证)
     *
     */
    public static function changeUserPasswordDirect (int $userId, string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPasswordDirect(["userId" => $userId, "password" => $password, ]);
    }
    /**
     * (海马体对接)忘记密码
     *
     */
    public static function changeUserPasswordDirectByMobile (int $phone, string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserPasswordDirectByMobile(["phone" => $phone, "password" => $password, ]);
    }
    /**
     * 通过用户id获取用户的信息 [废弃]
     *
     */
    public static function useUserIdGetUserInfo (array $user_id = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useUserIdGetUserInfo(["user_id" => $user_id, ]);
    }
    /**
     * 通过用户ids获取用户信息
     *
     */
    public static function getUserByIds (array $userIds, bool $withHidden = false, bool $withTags = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserByIds(["userIds" => $userIds, "withHidden" => $withHidden, "withTags" => $withTags, ]);
    }
    /**
     * 获取我的邀请人数.迁移为ddd
     *
     */
    public static function getUserInvite (int $user_id): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInvite(["user_id" => $user_id, ]);
    }
    /**
     * 根据unionId查询用户
     *
     */
    public static function queryUserByUnionId (string $unionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryUserByUnionId(["unionId" => $unionId, ]);
    }
    /**
     * 忘记用户密码.迁移为ddd
     *
     */
    public static function forgetUserPassword (string $phone, string $captcha, string $password): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "captcha" => $captcha, "password" => $password, ]);
    }
    /**
     * 查找相关联的用户.迁移为ddd
     *
     */
    public static function getUserData (string $name, string $phone, array $userIds, bool $withPwd, bool $withTags, bool $withDel, string $unionId, array $unionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserData(["name" => $name, "phone" => $phone, "userIds" => $userIds, "withPwd" => $withPwd, "withTags" => $withTags, "withDel" => $withDel, "unionId" => $unionId, "unionIds" => $unionIds, ]);
    }
    /**
     * 登录时更新用户信息
     *
     */
    public static function syncWechatUserInfo (int $user_id, string $head_img, array $wx_info): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncWechatUserInfo(["user_id" => $user_id, "head_img" => $head_img, "wx_info" => $wx_info, ]);
    }
    /**
     * 获取用户列表.迁移为ddd
     *
     */
    public static function getUserList (string $nickname, string $phone, array $phones, string $create_time_start, string $create_time_end , bool $with_del, int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserList(["nickname" => $nickname, "phone" => $phone, "phones" => $phones, "create_time_start" => $create_time_start, "create_time_end " => $create_time_end , "with_del" => $with_del, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 注销并修改用户手机号.迁移为ddd
     *
     */
    public static function logoutAndChangeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->logoutAndChangeUserPhone(["newPhone" => $newPhone, "oldPhone" => $oldPhone, "code" => $code, "certificate" => $certificate, ]);
    }
    /**
     * 修改用户邀请信息.迁移为ddd
     *
     */
    public static function saveInviter (int $userId, int $inviterUserId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveInviter(["userId" => $userId, "inviterUserId" => $inviterUserId, ]);
    }
    /**
     * 获取用户邀请数量.迁移为ddd
     *
     */
    public static function getUserInviteNum (int $userId): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInviteNum(["userId" => $userId, ]);
    }
    /**
     * 删除用户信息.迁移为ddd
     *
     */
    public static function deleteUsers (array $userIds): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteUsers(["userIds" => $userIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}