<?php
namespace Mainto\Bridge\Invokes\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryRecordsPageByParams(array $params)
 * @method changeUserPhoneByParams(array $params)
 */
class ChangePhoneRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分页列表
     *
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $oldPhone 原手机号 [ require false ]
     * @support  string $newPhone 新手机号 [ require false ]
     * @support  string $verifyMode 验证方式 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页面大小 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryRecordsPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->queryRecordsPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新手机号
     *
     * @param  string $oldPhone 原手机号 [ require true ]
     * @param  string $newPhone 新手机号 [ require true ]
     * @param  string $verifyMode 验证方式 [ require true ]
     * @param  array $extend 验证方式 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeUserPhone (string $oldPhone, string $newPhone, string $verifyMode, array $extend) {
        return self::getClass()->changeUserPhone([
            "oldPhone" => $oldPhone,
            "newPhone" => $newPhone,
            "verifyMode" => $verifyMode,
            "extend" => $extend,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'ChangePhoneRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'ChangePhoneRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}