<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStudentEducationByParams(array $params)
 * @method getStudentEducationInfoByParams(array $params)
 */
class StudentEducationNew {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建学生用户教育信息
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  string $degree 学历 [ require true ]
     * @param  string $enrollDate 入学年份 [ require true ]
     * @param  string $schoolName 学校名称 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\StudentEducation\StudentEducationDTO
     */
    public static function createStudentEducation (int $userId, string $degree, string $enrollDate, string $schoolName) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createStudentEducation([
                            "userId" => $userId,
                            "degree" => $degree,
                            "enrollDate" => $enrollDate,
                            "schoolName" => $schoolName,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\StudentEducation\StudentEducationDTO"
        );
    }

    /**
     * 获得用户教育信息
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\StudentEducation\StudentEducationDTO
     */
    public static function getStudentEducationInfo (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStudentEducationInfo([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\StudentEducation\StudentEducationDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\StudentEducationNew');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\StudentEducationNew');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}