<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllIndustriesByParams(array $params)
 * @method getPositionsByParams(array $params)
 * @method getPositionInfoByParams(array $params)
 */
class ProfessionNew {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取全部行业列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\Profession\IndustryDTO[]
     */
    public static function getAllIndustries () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllIndustries(),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\Profession\IndustryDTO[]"
        );
    }

    /**
     * 获取职位列表
     *
     * @param  int $industryId 行业ID [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionDTO[]
     */
    public static function getPositions (int $industryId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPositions([
                            "industryId" => $industryId,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionDTO[]"
        );
    }

    /**
     * 获取职位详情
     *
     * @param  int $positionId 职位ID [ require true ]
     * @param  bool $withIndustryInfo 包含岗位信息 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionDTO
     */
    public static function getPositionInfo (int $positionId, bool $withIndustryInfo = true) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPositionInfo([
                            "positionId" => $positionId,
                            "withIndustryInfo" => $withIndustryInfo,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\Profession\PositionDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\ProfessionNew');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\ProfessionNew');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}