<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addUserAddressByParams(array|\Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\AddUserAddressCmd $params)
 * @method updateUserAddressByParams(array|\Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\UpdateUserAddressCmd $params)
 * @method deleteUserAddressByParams(array $params)
 * @method getUserAddressesByParams(array $params)
 */
class UserAddressNew {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加用户地址
     *
     * @var  \Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\AddUserAddressCmd $addUserAddressCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addUserAddress (\Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\AddUserAddressCmd $addUserAddressCmd) {
        return self::getClass()->addUserAddress($addUserAddressCmd);
    }


    /**
     * 更新用户地址
     *
     * @var  \Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\UpdateUserAddressCmd $updateUserAddressCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateUserAddress (\Mainto\Bridge\Structs\User\Rpc\Cmd\UserAddress\UpdateUserAddressCmd $updateUserAddressCmd) {
        return self::getClass()->updateUserAddress($updateUserAddressCmd);
    }


    /**
     * 删除用户地址
     *
     * @param  int $addressId 地址ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteUserAddress (int $addressId) {
        return self::getClass()->deleteUserAddress([
            "addressId" => $addressId,
        ]);
    }

    /**
     * 获取用户地址列表
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\UserAddress\UserAddressDTO[]
     */
    public static function getUserAddresses (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserAddresses([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\UserAddress\UserAddressDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\UserAddressNew');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\UserAddressNew');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}