<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRecordByUserIdByParams(array $params)
 * @method getUserInviteCountByUserIdByParams(array $params)
 * @method saveInviterByParams(array $params)
 */
class RegisterRecordNew {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过用户ID获取注册记录
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\User\Rpc\DTO\RegisterRecord\RegisterRecordDTO
     */
    public static function getRecordByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRecordByUserId([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\User\Rpc\DTO\RegisterRecord\RegisterRecordDTO"
        );
    }

    /**
     * 获取我的邀请人数
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getUserInviteCountByUserId (int $userId) {
        return self::getClass()->getUserInviteCountByUserId([
            "userId" => $userId,
        ]);
    }

    /**
     * 修改用户邀请信息
     *
     * @param  int $userId 被邀请人用户ID [ require true ]
     * @param  int $inviterUserId 邀请人用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveInviter (int $userId, int $inviterUserId) {
        return self::getClass()->saveInviter([
            "userId" => $userId,
            "inviterUserId" => $inviterUserId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\RegisterRecordNew');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\RegisterRecordNew');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}