<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addUserByParams(array $params)
 * @method addNewUserByParams(array $params)
 * @method registerUserSmsCodeByParams(array $params)
 * @method getUserIdByParams(array $params)
 * @method getUserIdByEmailByParams(array $params)
 * @method getUserIdBatchByPhoneByParams(array $params)
 * @method addUserInfoByParams(array $params)
 * @method getUserListByFirstLoginByParams(array $params)
 * @method addNewUserForAuthLoginByParams(array $params)
 * @method changeUserPhoneByParams(array $params)
 * @method changeUserInfoByParams(array $params)
 * @method editUserByParams(array $params)
 * @method changeUserUnionIdByParams(array $params)
 * @method checkUserPasswordByParams(array $params)
 * @method checkUserPasswordByLoginByParams(array $params)
 * @method checkUserExistByParams(array $params)
 * @method changUserPasswordByParams(array $params)
 * @method changeUserPasswordDirectByParams(array $params)
 * @method saveUserPasswordForFirstByParams(array $params)
 * @method changeUserPasswordDirectByMobileByParams(array $params)
 * @method getRelationUserDataByParams(array $params)
 * @method useUserIdGetUserInfoByParams(array $params)
 * @method getUserByIdsByParams(array $params)
 * @method getUserInviteByParams(array $params)
 * @method queryUserByUnionIdByParams(array $params)
 * @method forgetUserPasswordByParams(array $params)
 * @method getUserDataByParams(array $params)
 * @method syncWechatUserInfoByParams(array $params)
 * @method getUserListByParams(array $params)
 * @method logoutAndChangeUserPhoneByParams(array $params)
 * @method saveInviterByParams(array $params)
 * @method getUserInviteNumByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 注册用户
     *
     * @param  string $phone 手机号 [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $sex 性别 require false
     * @support  string $name 用户昵称 require false
     * @support  string $headImg 头像 require false
     * @support  string $unionId 用户unionId require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addUser (string $phone) {
        return self::getClass()->addUser([
            "phone" => $phone,
        ]);
    }

    /**
     * 注册用户-作废
     * @deprecated
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @param  string $unionId 用户unionId [ require true ]
     * @param  string $headImg 头像 [ require true ]
     * @param  string $sex 性别 [ require true ]
     * @param  string $name 用户昵称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewUser (string $phone, string $password, string $unionId = '', string $headImg = '', string $sex = null, string $name = '') {
        return self::getClass()->addNewUser([
            "phone" => $phone,
            "password" => $password,
            "unionId" => $unionId,
            "headImg" => $headImg,
            "sex" => $sex,
            "name" => $name,
        ]);
    }

    /**
     * 通过短信验证码注册用户
     * @deprecated
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @param  string $sex 用户性别 [ require true ]
     * @param  string $headImg 头像 [ require true ]
     * @param  string $name 用户昵称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function registerUserSmsCode (string $phone, string $captcha, string $password, string $sex = null, string $headImg = '', string $name = '') {
        return self::getClass()->registerUserSmsCode([
            "phone" => $phone,
            "captcha" => $captcha,
            "password" => $password,
            "sex" => $sex,
            "headImg" => $headImg,
            "name" => $name,
        ]);
    }

    /**
     * 通过手机号查询userid
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  bool $noExistAddNew 如果不存在是否新增一个 [ require true ]
     * @param  bool $checkFirstLogin 检查是否首次登录-参数作废 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserId (string $phone, bool $noExistAddNew = true, bool $checkFirstLogin = false) {
        return self::getClass()->getUserId([
            "phone" => $phone,
            "noExistAddNew" => $noExistAddNew,
            "checkFirstLogin" => $checkFirstLogin,
        ]);
    }

    /**
     * 邮箱查询user_id
     * @deprecated
     *
     * @param  string $email 邮箱 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserIdByEmail (string $email) {
        return self::getClass()->getUserIdByEmail([
            "email" => $email,
        ]);
    }

    /**
     * 批量根据手机号获取用户id
     * @deprecated
     *
     * @param  array $phones 手机号s [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserIdBatchByPhone (array $phones) {
        return self::getClass()->getUserIdBatchByPhone([
            "phones" => $phones,
        ]);
    }

    /**
     * 新增一条用户数据
     *
     * @support  string $password 密码 [ require true ]
     * @support  string $name 用户昵称 require false
     * @param  string $phone 用户手机号 [ require true ]
     * @support  string $unionId unionId require false
     * @support  string $birth 生日 require false
     * @support  string $headSculpture 微信头像 require false
     * @support  string $address 用户地址 require false
     * @support  string $sex 用户性别 require false
     * @support  string $email 用户邮箱 require false
     * @support  string $register 注册来源 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addUserInfo (string $phone) {
        return self::getClass()->addUserInfo([
            "phone" => $phone,
        ]);
    }

    /**
     * 根据首次登录时间查询用户列表
     * @deprecated
     *
     * @param  string $endTime 结束时间 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserListByFirstLogin (string $startTime, string $endTime, int $page = 1, int $pageSize = 15) {
        return self::getClass()->getUserListByFirstLogin([
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 认证注册添加用户
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $register 注册来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewUserForAuthLogin (string $phone, string $register) {
        return self::getClass()->addNewUserForAuthLogin([
            "phone" => $phone,
            "register" => $register,
        ]);
    }

    /**
     * 修改用户手机号
     * @deprecated
     *
     * @param  string $newPhone 新手机号 [ require true ]
     * @param  string $oldPhone 旧手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @param  string $certificate 用户沟通凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate) {
        return self::getClass()->changeUserPhone([
            "newPhone" => $newPhone,
            "oldPhone" => $oldPhone,
            "code" => $code,
            "certificate" => $certificate,
        ]);
    }

    /**
     * 修改用户相关信息-作废
     *
     * @support  string $union_id 微信unionId require false
     * @param  int $user_id 用户id [ require true ]
     * @support  string $head_sculpture 微信头像 require false
     * @support  string $name 用户昵称 require false
     * @support  string $birth 用户生日 require false
     * @support  string $sex 用户性别 require false
     * @support  string $address 地址 require false
     * @support  string $email 用户邮箱 require false
     * @support  int $position_id 职位ID require false
     * @support  int $city_id 城市ID require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserInfo (int $user_id) {
        return self::getClass()->changeUserInfo([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 编辑用户相关信息
     *
     * @support  string $unionId 微信unionId require false
     * @param  int $userId 用户id [ require true ]
     * @support  string $headSculpture 微信头像 require false
     * @support  string $name 用户昵称 require false
     * @support  string $birth 用户生日 require false
     * @support  string $sex 用户性别 require false
     * @support  string $address 地址 require false
     * @support  string $email 用户邮箱 require false
     * @support  int $positionId 职位ID require false
     * @support  int $cityId 城市ID require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUser (int $userId) {
        return self::getClass()->editUser([
            "userId" => $userId,
        ]);
    }

    /**
     * 更改用户union id
     *
     * @param  string $union_id 用户unionid [ require true ]
     * @param  int $user_id 用户userid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserUnionId (string $union_id, int $user_id) {
        return self::getClass()->changeUserUnionId([
            "union_id" => $union_id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 核对用户密码
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserPassword (string $phone, string $password) {
        return self::getClass()->checkUserPassword([
            "phone" => $phone,
            "password" => $password,
        ]);
    }

    /**
     * 校验用户密码-用户登录
     * @deprecated
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserPasswordByLogin (string $phone, string $password) {
        return self::getClass()->checkUserPasswordByLogin([
            "phone" => $phone,
            "password" => $password,
        ]);
    }

    /**
     * 判断用户是否存在
     *
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserExist (string $phone) {
        return self::getClass()->checkUserExist([
            "phone" => $phone,
        ]);
    }

    /**
     * 用户修改密码
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $old_password 用户老密码 [ require true ]
     * @param  string $new_password 用户新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserPassword (int $user_id, string $old_password, string $new_password) {
        return self::getClass()->changUserPassword([
            "user_id" => $user_id,
            "old_password" => $old_password,
            "new_password" => $new_password,
        ]);
    }

    /**
     * 直接修改用户密码(不进行旧密码验证)
     * @deprecated
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $password 密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPasswordDirect (int $userId, string $password) {
        return self::getClass()->changeUserPasswordDirect([
            "userId" => $userId,
            "password" => $password,
        ]);
    }

    /**
     * 首次保存用户密码【用户登录后首次设置密码】
     * @deprecated
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $password 密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveUserPasswordForFirst (int $userId, string $password) {
        return self::getClass()->saveUserPasswordForFirst([
            "userId" => $userId,
            "password" => $password,
        ]);
    }

    /**
     * (海马体对接)忘记密码
     * @deprecated
     *
     * @param  int $phone 手机号 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPasswordDirectByMobile (int $phone, string $password) {
        return self::getClass()->changeUserPasswordDirectByMobile([
            "phone" => $phone,
            "password" => $password,
        ]);
    }

    /**
     * 模糊查找相关联的用户
     * @deprecated
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $name 用户名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRelationUserData (string $phone = '', string $name = '') {
        return self::getClass()->getRelationUserData([
            "phone" => $phone,
            "name" => $name,
        ]);
    }

    /**
     * 通过用户id获取用户的信息 [废弃]
     * @deprecated
     *
     * @param  array $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useUserIdGetUserInfo (array $user_id = []) {
        return self::getClass()->useUserIdGetUserInfo([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 通过用户ids获取用户信息
     * @deprecated
     *
     * @param  array $userIds 用户ids [ require true ]
     * @param  bool $withHidden 是否需要隐藏字段 [ require true ]
     * @param  bool $withTags 是否包含标签 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserByIds (array $userIds, bool $withHidden = false, bool $withTags = true) {
        return self::getClass()->getUserByIds([
            "userIds" => $userIds,
            "withHidden" => $withHidden,
            "withTags" => $withTags,
        ]);
    }

    /**
     * 获取我的邀请人数
     *
     * @param  int $user_id 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInvite (int $user_id) {
        return self::getClass()->getUserInvite([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 根据unionId查询用户
     * @deprecated
     *
     * @param  string $unionId 用户UnionId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryUserByUnionId (string $unionId) {
        return self::getClass()->queryUserByUnionId([
            "unionId" => $unionId,
        ]);
    }

    /**
     * 忘记用户密码
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forgetUserPassword (string $phone, string $captcha, string $password) {
        return self::getClass()->forgetUserPassword([
            "phone" => $phone,
            "captcha" => $captcha,
            "password" => $password,
        ]);
    }

    /**
     * 查找相关联的用户
     *
     * @support  string $name 用户名称 require false
     * @support  string $phone 用户手机号 require false
     * @support  array $userIds 用户ids require false
     * @support  bool $withPwd 包含密码 require false
     * @support  bool $withTags 是否包含标签 require false
     * @support  string $unionId 用户UnionId require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserData () {
        return self::getClass()->getUserData();
    }

    /**
     * 登录时更新用户信息
     * @deprecated
     *
     * @param  int $user_id 用户uid [ require true ]
     * @support  string $head_img 头像 require false
     * @support  array $wx_info 用户微信信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncWechatUserInfo (int $user_id) {
        return self::getClass()->syncWechatUserInfo([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取用户列表
     *
     * @support  string $nickname 用户昵称 require false
     * @support  string $phone 手机号 require false
     * @support  array $phones 批量手机号 require false
     * @support  string $create_time_start 注册时间-开始 require false
     * @support  string $create_time_end  注册时间-结束 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserList () {
        return self::getClass()->getUserList();
    }

    /**
     * 注销并修改用户手机号
     *
     * @param  string $newPhone 新手机号 [ require true ]
     * @param  string $oldPhone 旧手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @param  string $certificate 用户沟通凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function logoutAndChangeUserPhone (string $newPhone, string $oldPhone, string $code, string $certificate) {
        return self::getClass()->logoutAndChangeUserPhone([
            "newPhone" => $newPhone,
            "oldPhone" => $oldPhone,
            "code" => $code,
            "certificate" => $certificate,
        ]);
    }

    /**
     * 修改用户邀请信息
     *
     * @param  int $userId 被邀请人用户ID [ require true ]
     * @param  int $inviterUserId 邀请人用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveInviter (int $userId, int $inviterUserId) {
        return self::getClass()->saveInviter([
            "userId" => $userId,
            "inviterUserId" => $inviterUserId,
        ]);
    }

    /**
     * 获取用户邀请数量
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInviteNum (int $userId) {
        return self::getClass()->getUserInviteNum([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}