<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addInvoiceTitleByParams(array|InvoiceTitle\AddInvoiceTitle\AddInvoiceTitleCmd $params)
 * @method updateInvoiceTitleByParams(array|InvoiceTitle\UpdateInvoiceTitle\SaveInvoiceTitleCmd $params)
 * @method deleteInvoiceTitleByParams(array $params)
 * @method invoiceTitleInfoByParams(array $params)
 * @method invoiceTitleListByParams(array|InvoiceTitle\InvoiceTitleList\InvoiceTitleListCmd $params)
 * @method setIsDefaultByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加抬头
     *
     * @var  InvoiceTitle\AddInvoiceTitle\AddInvoiceTitleCmd $addInvoiceTitleCmd $addInvoiceTitleCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addInvoiceTitle (InvoiceTitle\AddInvoiceTitle\AddInvoiceTitleCmd $addInvoiceTitleCmd) {
        return self::getClass()->addInvoiceTitle($addInvoiceTitleCmd);
    }


    /**
     * 修改抬头
     *
     * @var  InvoiceTitle\UpdateInvoiceTitle\SaveInvoiceTitleCmd $saveInvoiceTitleCmd $saveInvoiceTitleCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateInvoiceTitle (InvoiceTitle\UpdateInvoiceTitle\SaveInvoiceTitleCmd $saveInvoiceTitleCmd) {
        return self::getClass()->updateInvoiceTitle($saveInvoiceTitleCmd);
    }


    /**
     * 删除发票抬头
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteInvoiceTitle (int $invoiceTitleId) {
        return self::getClass()->deleteInvoiceTitle([
            "invoiceTitleId" => $invoiceTitleId,
        ]);
    }

    /**
     * 发票抬头详情
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  InvoiceTitle\InvoiceTitleInfo\InvoiceTitleDTO
     */
    public static function invoiceTitleInfo (int $invoiceTitleId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->invoiceTitleInfo([
                            "invoiceTitleId" => $invoiceTitleId,
                        ]),
            "\Mainto\Bridge\Invokes\User\Rpc\InvoiceTitle\InvoiceTitleInfo\InvoiceTitleDTO"
        );
    }

    /**
     * 用户发票抬头列表
     *
     * @var  InvoiceTitle\InvoiceTitleList\InvoiceTitleListCmd $invoiceTitleListCmd $invoiceTitleListCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoiceTitleList (InvoiceTitle\InvoiceTitleList\InvoiceTitleListCmd $invoiceTitleListCmd) {
        return self::getClass()->invoiceTitleList($invoiceTitleListCmd);
    }


    /**
     * 设置为默认发票抬头
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setIsDefault (int $invoiceTitleId) {
        return self::getClass()->setIsDefault([
            "invoiceTitleId" => $invoiceTitleId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}