<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method infoByParams(array $params)
 * @method createByParams(array $params)
 */
class StudentEducate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 教育信息查询
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info (int $userId, string $state) {
        return self::getClass()->info([
            "userId" => $userId,
            "state" => $state,
        ]);
    }

    /**
     * 创建学生用户教育信息
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $enrollDate 入学年份 require false
     * @support  string $degree 学历 [ require true ]
     * @support  string $schoolName 学校名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'User\StudentEducate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'User\StudentEducate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}