<?php
namespace Mainto\Bridge\Enums\User;

class StudentDegreeEnum {
    /**
     * 专科
     */
    const SPECIALTY = 'specialty';
    /**
     * 本科
     */
    const UNDERGRADUATE = 'undergraduate';
    /**
     * 研究生
     */
    const POSTGRADUATE = 'postgraduate';
    /**
     * 博士
     */
    const DOCTOR = 'doctor';
    /**
     * 本硕连读
     */
    const BACHELOR_MASTER = 'bachelor_master';
    /**
     * 硕博连读
     */
    const MASTER_DOCTORAL = 'master_doctoral';
    /**
     * 本硕博连读
     */
    const BACHELOR_DOCTORAL = 'bachelor_doctoral';
    /**
     * 所有教育枚举
     */
    const ALL_EDUCATION = [0 => 'specialty',1 => 'undergraduate',2 => 'postgraduate',3 => 'doctor',4 => 'bachelor_master',5 => 'master_doctoral'];
    /**
     * 支付宝学生认证教育枚举关系map
     */
    const AlipayStudentCertificateDegreeRelationMap = [0 => 'specialty',1 => 'undergraduate',2 => 'postgraduate',3 => 'doctor',4 => 'bachelor_master',5 => 'master_doctoral',6 => 'bachelor_doctoral'];
}