<?php
namespace Mainto\Bridge\Invokes\User\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userTagListByParams(array $params)
 */
class UserTags {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标签查询
     *
     * @param  array $userIds 用户Ids [ require true ]
     * @param  string $tagName tag标签 [ require true ]
     * @param  int $page 页数 [ require true ]
     * @param  int $pageSize 分页数 [ require true ]
     * @throws  \Exception
     * @return  UserTags\UserTagList\UserTagListDTO
     */
    public static function userTagList (array $userIds, string $tagName, int $page = 1, int $pageSize = 10) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->userTagList([
                            "userIds" => $userIds,
                            "tagName" => $tagName,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Invokes\User\Rpc\UserTags\UserTagList\UserTagListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Rpc\UserTags');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Rpc\UserTags');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}