<?php
namespace Mainto\Bridge\Invokes\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userLoginByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 海马体公众号登录事件监听
     *
     * @param  string $brand 登录平台 [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @param  array $wxInfo 用户信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userLogin (int $userId, string $brand, array $wxInfo = []) {
        return self::getClass()->userLogin([
            "userId" => $userId,
            "brand" => $brand,
            "wxInfo" => $wxInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}