<?php
namespace Mainto\Bridge\Invokes\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method himoLoginByParams(array $params)
 * @method himoAppLoginByParams(array $params)
 * @method mantuAppAppLoginByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 海马体公众号登录事件监听
     *
     * @param  string $brand 登录平台 [ require true ]
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoLogin (int $userId, string $brand) {
        return self::getClass()->himoLogin([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * 海马体小程序登录事件监听
     *
     * @param  string $brand 登录平台 [ require true ]
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoAppLogin (int $userId, string $brand) {
        return self::getClass()->himoAppLogin([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * 海马体app登录事件监听
     *
     * @param  string $brand 登录平台 [ require true ]
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuAppAppLogin (int $userId, string $brand) {
        return self::getClass()->mantuAppAppLogin([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}