<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveSubscribeByParams(array $params)
 * @method deleteByOpenIdByParams(array $params)
 * @method getSubscribeListByParams(array $params)
 * @method getInfoByOpenIdByParams(array $params)
 */
class UserSubscribe {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户关注记录
     *
     * @param  string $openId open id [ require true ]
     * @param  string $unionId union id [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSubscribe (string $openId, string $unionId, string $brand) {
        return self::getClass()->saveSubscribe([
            "openId" => $openId,
            "unionId" => $unionId,
            "brand" => $brand,
        ]);
    }

    /**
     * 取关公众号删除记录
     *
     * @param  string $openId openid [ require true ]
     * @param  string $brand 平台 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function deleteByOpenId (string $openId, string $brand) {
        return self::getClass()->deleteByOpenId([
            "openId" => $openId,
            "brand" => $brand,
        ]);
    }

    /**
     * 分页查询-关注列表
     *
     * @support  array $userIds 用户IDs [Original type array&lt;uint&gt;] 
     * @support  string $brand 模块 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSubscribeList () {
        return self::getClass()->getSubscribeList();
    }

    /**
     * 通过openid获取关注详情
     *
     * @param  string $openid openid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoByOpenId (string $openid) {
        return self::getClass()->getInfoByOpenId([
            "openid" => $openid,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'User\UserSubscribe');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'User\UserSubscribe');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}