<?php
namespace Mainto\Bridge\Invokes\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllIndustriesByParams(array $params)
 * @method getPositionsByParams(array $params)
 * @method getPositionInfoByParams(array $params)
 */
class Profession {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取全部行业列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllIndustries () {
        return self::getClass()->getAllIndustries();
    }

    /**
     * 获取职位列表
     *
     * @support  int $industryId 行业ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPositions () {
        return self::getClass()->getPositions();
    }

    /**
     * 获取职位详情
     *
     * @param  int $positionId 职位ID [Original type uint] [ require true ]
     * @param  bool $withIndustryInfo 包含岗位信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionInfo (int $positionId, bool $withIndustryInfo) {
        return self::getClass()->getPositionInfo([
            "positionId" => $positionId,
            "withIndustryInfo" => $withIndustryInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Profession');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Profession');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}