<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createFlowByParams(array $params)
 * @method currentLevelByParams(array $params)
 * @method unbindOrderByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method getFlowByUidByParams(array $params)
 * @method fixScoreByParams(array $params)
 * @method getAllWelfareByParams(array $params)
 * @method addWelfareByParams(array $params)
 * @method editWelfareByParams(array $params)
 * @method queryUpgradeCondByParams(array $params)
 * @method bindMemberCardByParams(array $params)
 * @method activeMemberCardByParams(array $params)
 * @method calcMemberForOneByParams(array $params)
 */
class Member {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建用户流水
     *
     * @param  int $userId 用户uid [Original type uint] [ require true ]
     * @param  string $flowType 流水类型 [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  int $subOrderId 子订单id [Original type uint] [ require true ]
     * @param  float $money 金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createFlow (int $userId, int $orderId, int $subOrderId, string $flowType, float $money) {
        return self::getClass()->createFlow([
            "userId" => $userId,
            "orderId" => $orderId,
            "subOrderId" => $subOrderId,
            "flowType" => $flowType,
            "money" => $money,
        ]);
    }

    /**
     * 获取当前用户的等级
     *
     * @param  int $integral 积分 [Original type uint] [ require true ]
     * @param  int $consumeNum 消费次数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function currentLevel (int $integral, int $consumeNum) {
        return self::getClass()->currentLevel([
            "integral" => $integral,
            "consumeNum" => $consumeNum,
        ]);
    }

    /**
     * 解绑订单
     *
     * @param  array $order 订单id [ require true ]
     * @param  int $userId 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindOrder (int $userId, array $order) {
        return self::getClass()->unbindOrder([
            "userId" => $userId,
            "order" => $order,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  array $order 订单 [ require true ]
     * @param  array $refunds 退款流水 [ require true ]
     * @param  int $userId 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $userId, array $order, array $refunds = []) {
        return self::getClass()->bindOrder([
            "userId" => $userId,
            "order" => $order,
            "refunds" => $refunds,
        ]);
    }

    /**
     * 根据uid获取流水
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $flowType 流水类型 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFlowByUid (int $userId, string $flowType = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->getFlowByUid([
            "userId" => $userId,
            "flowType" => $flowType,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 用户积分修正
     *
     * @support  int $score 用户增加/减少积分 [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @support  string $scene 公众号 [ require true ]
     * @support  string $card_id 卡id [ require true ]
     * @support  int $user_consume_num 用户消费次数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixScore () {
        return self::getClass()->fixScore();
    }

    /**
     * 查询所有会员权益
     *
     * @param  bool $sortDesc 排序倒叙 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllWelfare (bool $sortDesc = false) {
        return self::getClass()->getAllWelfare([
            "sortDesc" => $sortDesc,
        ]);
    }

    /**
     * 增加权益规则
     *
     * @param  string $welfareName 权益名称 [ require true ]
     * @param  string $welfareIcon 权益图片 [ require true ]
     * @param  string $welfareNote 权益备注 [ require true ]
     * @param  array $memberLevel 所属等级 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addWelfare (string $welfareName, string $welfareIcon, string $welfareNote, array $memberLevel, int $sort) {
        return self::getClass()->addWelfare([
            "welfareName" => $welfareName,
            "welfareIcon" => $welfareIcon,
            "welfareNote" => $welfareNote,
            "memberLevel" => $memberLevel,
            "sort" => $sort,
        ]);
    }

    /**
     * 修改权益
     *
     * @param  int $welfareId 规则id [ require true ]
     * @param  string $welfareName 权益名称 [ require true ]
     * @param  string $welfareIcon 权益图片 [ require true ]
     * @param  string $welfareNote 权益备注 [ require true ]
     * @param  array $memberLevel 所属等级 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWelfare (int $welfareId, string $welfareName = '', string $welfareIcon = '', string $welfareNote = '', array $memberLevel = [], int $sort = 0) {
        return self::getClass()->editWelfare([
            "welfareId" => $welfareId,
            "welfareName" => $welfareName,
            "welfareIcon" => $welfareIcon,
            "welfareNote" => $welfareNote,
            "memberLevel" => $memberLevel,
            "sort" => $sort,
        ]);
    }

    /**
     * 查询用户升级条件
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryUpgradeCond (int $userId) {
        return self::getClass()->queryUpgradeCond([
            "userId" => $userId,
        ]);
    }

    /**
     * 绑定会员卡
     *
     * @param  int $userId 用户uid [ require true ]
     * @param  string $cardId 微信会员卡ID [ require true ]
     * @param  string $cardCode 会员会员卡Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindMemberCard (int $userId, string $cardId, string $cardCode) {
        return self::getClass()->bindMemberCard([
            "userId" => $userId,
            "cardId" => $cardId,
            "cardCode" => $cardCode,
        ]);
    }

    /**
     * 激活会员卡
     *
     * @param  int $userId 用户uid [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @param  string $birth 生日 [ require true ]
     * @param  string $sex 性别 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $email 邮箱 [ require true ]
     * @param  string $mailingAddress 邮寄地址 [ require true ]
     * @param  array $attentionProductTypes 关注的产品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function activeMemberCard (int $userId, string $name, string $birth, string $sex, string $phone, string $email = '', string $mailingAddress = '', array $attentionProductTypes = []) {
        return self::getClass()->activeMemberCard([
            "userId" => $userId,
            "name" => $name,
            "birth" => $birth,
            "sex" => $sex,
            "phone" => $phone,
            "email" => $email,
            "mailingAddress" => $mailingAddress,
            "attentionProductTypes" => $attentionProductTypes,
        ]);
    }

    /**
     * 测试用 年审某个用户会员
     *
     * @param  int $user_id 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calcMemberForOne (int $user_id) {
        return self::getClass()->calcMemberForOne([
            "user_id" => $user_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Member');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Member');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}