<?php
namespace Mainto\Bridge\Invokes\User\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createFlowByParams(array $params)
 * @method changeFlowBindUserByParams(array $params)
 * @method getFlowByUidByParams(array $params)
 * @method getAllWelfareByParams(array $params)
 * @method addWelfareByParams(array $params)
 * @method editWelfareByParams(array $params)
 * @method queryUpgradeCondByParams(array $params)
 * @method bindMemberCardByParams(array $params)
 * @method activeMemberCardByParams(array $params)
 */
class Member {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建用户流水
     *
     * @param  int $userId 用户uid [ require true ]
     * @param  string $flowType 流水类型 [ require true ]
     * @param  string $orderNum 订单号 [ require true ]
     * @param  float $money 金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createFlow (int $userId, string $orderNum, string $flowType, float $money) {
        return self::getClass()->createFlow([
            "userId" => $userId,
            "orderNum" => $orderNum,
            "flowType" => $flowType,
            "money" => $money,
        ]);
    }

    /**
     * 改变流水所属用户
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @param  int $newUserId 新用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeFlowBindUser (string $orderNum, int $newUserId) {
        return self::getClass()->changeFlowBindUser([
            "orderNum" => $orderNum,
            "newUserId" => $newUserId,
        ]);
    }

    /**
     * 根据uid获取流水
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $flowType 流水类型 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFlowByUid (int $userId, string $flowType = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->getFlowByUid([
            "userId" => $userId,
            "flowType" => $flowType,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 查询所有会员权益
     *
     * @param  bool $sortDesc 排序倒叙 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllWelfare (bool $sortDesc = false) {
        return self::getClass()->getAllWelfare([
            "sortDesc" => $sortDesc,
        ]);
    }

    /**
     * 增加权益规则
     *
     * @param  string $welfareName 权益名称 [ require true ]
     * @param  string $welfareIcon 权益图片 [ require true ]
     * @param  string $welfareNote 权益备注 [ require true ]
     * @param  array $memberLevel 所属等级 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addWelfare (string $welfareName, string $welfareIcon, string $welfareNote, array $memberLevel, int $sort) {
        return self::getClass()->addWelfare([
            "welfareName" => $welfareName,
            "welfareIcon" => $welfareIcon,
            "welfareNote" => $welfareNote,
            "memberLevel" => $memberLevel,
            "sort" => $sort,
        ]);
    }

    /**
     * 修改权益
     *
     * @param  int $welfareId 规则id [ require true ]
     * @param  string $welfareName 权益名称 [ require true ]
     * @param  string $welfareIcon 权益图片 [ require true ]
     * @param  string $welfareNote 权益备注 [ require true ]
     * @param  array $memberLevel 所属等级 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWelfare (int $welfareId, string $welfareName = '', string $welfareIcon = '', string $welfareNote = '', array $memberLevel = [], int $sort = 0) {
        return self::getClass()->editWelfare([
            "welfareId" => $welfareId,
            "welfareName" => $welfareName,
            "welfareIcon" => $welfareIcon,
            "welfareNote" => $welfareNote,
            "memberLevel" => $memberLevel,
            "sort" => $sort,
        ]);
    }

    /**
     * 查询用户升级条件
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryUpgradeCond (int $userId) {
        return self::getClass()->queryUpgradeCond([
            "userId" => $userId,
        ]);
    }

    /**
     * 绑定会员卡
     *
     * @param  int $userId 用户uid [ require true ]
     * @param  string $cardId 微信会员卡ID [ require true ]
     * @param  string $cardCode 会员会员卡Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindMemberCard (int $userId, string $cardId, string $cardCode) {
        return self::getClass()->bindMemberCard([
            "userId" => $userId,
            "cardId" => $cardId,
            "cardCode" => $cardCode,
        ]);
    }

    /**
     * 激活会员卡
     *
     * @param  string $cardId 微信会员卡ID [ require true ]
     * @param  string $cardCode 会员会员卡Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function activeMemberCard (string $cardId, string $cardCode) {
        return self::getClass()->activeMemberCard([
            "cardId" => $cardId,
            "cardCode" => $cardCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('User', 'Member');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('User', 'Member');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}