<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-20 10:22:40
 */
namespace Mainto\Bridge\Structs\UserMember\SweetMember\Cmd;

class PaginateSweetMemberIntegralChangeLogsCmd {
    /**
     * @var  int
     * 会员id
     * validation: 
     */
    public int $userId;
    /**
     * @var  string
     * 分值变动类型
     * validation: in:withdraw
     */
    public string $type;
    /**
     * @var  string
     * 创建时间-开始
     * validation: sometimes|date_format:Y-m-d H:i:s
     */
    public string $createdAtStart;
    /**
     * @var  string
     * 创建时间-结束
     * validation: sometimes|date_format:Y-m-d H:i:s|after:createdAtStart
     */
    public string $createdAtEnd;
    /**
     * @var  int
     * 当前第N页。默认1
     * validation: gte:1
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页N条。默认20
     * validation: lte:200
     */
    public int $pageSize = 20;
    /**
     * @var  string
     * 排序字段。默认id字段排序
     * validation: in:id
     */
    public string $sortFiled = "id";
    /**
     * @var  string
     * 排序放心。默认desc
     * validation: in:asc,desc
     */
    public string $sortDirection = "desc";

    public function __construct (int $userId = 0, string $type = '', string $createdAtStart = '', string $createdAtEnd = '') {
        $this->userId = $userId;
        $this->type = $type;
        $this->createdAtStart = $createdAtStart;
        $this->createdAtEnd = $createdAtEnd;
    }

    public static function create(int $userId = 0, string $type = '', string $createdAtStart = '', string $createdAtEnd = ''): self {
        return new self($userId, $type, $createdAtStart, $createdAtEnd);
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setCreatedAtStart(string $createdAtStart): self {
        $this->createdAtStart = $createdAtStart;

        return $this;
    }

    public function setCreatedAtEnd(string $createdAtEnd): self {
        $this->createdAtEnd = $createdAtEnd;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }

    public function setSortFiled(string $sortFiled): self {
        $this->sortFiled = $sortFiled;

        return $this;
    }

    public function setSortDirection(string $sortDirection): self {
        $this->sortDirection = $sortDirection;

        return $this;
    }
}