<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-20 10:22:40
 */
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MemberCard
 */
class MemberCard {
    private static string $serviceName = "UserMember";

    private static string $className = "MemberCard";

    /**
     * 获取会员卡列表--分页
     * @return  mixed
    */
    public static function getMemberCards (int $page = 1, int $pageSize = 20, string $receiveTimeStart, string $receiveTimeEnd, string $state, array $userIds, array $templateIds, array $sortBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberCards(["page" => $page, "pageSize" => $pageSize, "receiveTimeStart" => $receiveTimeStart, "receiveTimeEnd" => $receiveTimeEnd, "state" => $state, "userIds" => $userIds, "templateIds" => $templateIds, "sortBy" => $sortBy]);
    }
    /**
     * 获取会员卡详情
     * @return  mixed
    */
    public static function detail (int $cardId, bool $withCardTemplate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["cardId" => $cardId, "withCardTemplate" => $withCardTemplate]);
    }
    /**
     * 会员卡批量开启
     * @return  mixed
    */
    public static function bulkOpen (array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkOpen(["cardIds" => $cardIds]);
    }
    /**
     * 会员卡批量禁用
     * @return  mixed
    */
    public static function bulkForbidden (array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkForbidden(["cardIds" => $cardIds]);
    }
    /**
     * 获取会员卡列表
     * @return  mixed
    */
    public static function list (string $receiveTimeStart, string $receiveTimeEnd, string $state, array $userIds, array $templateIds, array $sortBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["receiveTimeStart" => $receiveTimeStart, "receiveTimeEnd" => $receiveTimeEnd, "state" => $state, "userIds" => $userIds, "templateIds" => $templateIds, "sortBy" => $sortBy]);
    }
    /**
     * 学生会员身份变更
     * @return  bool
    */
    public static function memberStudentIdentityChange (int $userId, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberStudentIdentityChange(["userId" => $userId, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}