<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-16 10:44:15
 */
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class HimoMember
 */
class HimoMember {
    private static string $serviceName = "UserMember";

    private static string $className = "Himo\\HimoMember";

    /**
     * 创建用户流水
     * @return  mixed
    */
    public static function createOrderFlow (int $userId, string $type, string $source, float $money, int $diffId, int $orderId, string $orderCreatedAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrderFlow(["userId" => $userId, "type" => $type, "source" => $source, "money" => $money, "diffId" => $diffId, "orderId" => $orderId, "orderCreatedAt" => $orderCreatedAt]);
    }
    /**
     * 创建用户流水
     * @return  bool
    */
    public static function batchCreateOrderFlow (int $userId, array $flowRecords) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreateOrderFlow(["userId" => $userId, "flowRecords" => $flowRecords]);
    }
    /**
     * 绑定订单
     * @return  mixed
    */
    public static function bindOrder (int $userId, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindOrder(["userId" => $userId, "orderId" => $orderId]);
    }
    /**
     * 解绑订单
     * @return  mixed
    */
    public static function unbindOrder (int $userId, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindOrder(["userId" => $userId, "orderId" => $orderId]);
    }
    /**
     * 通过积分或消费次数的计算等级
     * @return  mixed
    */
    public static function calcLevel (int $integral, int $consumeNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->calcLevel(["integral" => $integral, "consumeNum" => $consumeNum]);
    }
    /**
     * 查询用户升级目标
     * @return  mixed
    */
    public static function getUserUpgradeTarget (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserUpgradeTarget(["userId" => $userId]);
    }
    /**
     * 获取会员列表-分页
     * @return  mixed
    */
    public static function getMembers (int $page = 1, int $pageSize = 15, array $userIds, array $levels, array $consumeNumExp, string $birthStart, string $birthEnd, string $lastBuyTime, string $lastBuyTimeStart, string $lastBuyTimeEnd, array $sortBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMembers(["page" => $page, "pageSize" => $pageSize, "userIds" => $userIds, "levels" => $levels, "consumeNumExp" => $consumeNumExp, "birthStart" => $birthStart, "birthEnd" => $birthEnd, "lastBuyTime" => $lastBuyTime, "lastBuyTimeStart" => $lastBuyTimeStart, "lastBuyTimeEnd" => $lastBuyTimeEnd, "sortBy" => $sortBy]);
    }
    /**
     * 会员详情
     * @return  mixed
    */
    public static function getMemberInfo (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberInfo(["userId" => $userId]);
    }
    /**
     * 获取会员列表
     * @return  mixed
    */
    public static function list (array $userIds, array $levels, array $consumeNumExp, string $birthStart, string $birthEnd, string $lastBuyTime, string $lastBuyTimeStart, string $lastBuyTimeEnd, array $sortBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["userIds" => $userIds, "levels" => $levels, "consumeNumExp" => $consumeNumExp, "birthStart" => $birthStart, "birthEnd" => $birthEnd, "lastBuyTime" => $lastBuyTime, "lastBuyTimeStart" => $lastBuyTimeStart, "lastBuyTimeEnd" => $lastBuyTimeEnd, "sortBy" => $sortBy]);
    }
    /**
     * 修改会员相关信息
     * @return  mixed
    */
    public static function update (int $userId, string $birthYear, string $birthDate, bool $enablePush) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["userId" => $userId, "birthYear" => $birthYear, "birthDate" => $birthDate, "enablePush" => $enablePush]);
    }
    /**
     * 会员规则查询
     * @return  mixed
    */
    public static function getMemberRule () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberRule();
    }
    /**
     * 使用会员加急次数
     * @return  mixed
    */
    public static function useExpeditedTimes (int $userId, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useExpeditedTimes(["userId" => $userId, "orderId" => $orderId]);
    }
    /**
     * 获取当前用户的升级体验权益
     * @return  mixed
    */
    public static function getCurrentUpgradeWelfare (int $userId, string $brand = 'blue') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentUpgradeWelfare(["userId" => $userId, "brand" => $brand]);
    }
    /**
     * 获取用户勋章
     * @return  array
    */
    public static function getUserMedals (int $userId, array $multiStatus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserMedals(["userId" => $userId, "multiStatus" => $multiStatus]);
    }
    /**
     * 勋章确认
     * @return  mixed
    */
    public static function memberConfirm (int $userId, array $recordIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberConfirm(["userId" => $userId, "recordIds" => $recordIds]);
    }
    /**
     * 勋章领取
     * @return  mixed
    */
    public static function receiveMedal (int $userId, int $medalId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveMedal(["userId" => $userId, "medalId" => $medalId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}