<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-27 11:18:34
 */
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Points
 * @method receivePointsByParams(array $params) 领取积分
 * @method getPointsByParams(array $params) 积分变更查询-分页
 * @method listByParams(array $params) 积分变更查询-不分页
 * @method getCleanablePointsByParams(array $params) 获取用户待清理积分
 * @method consumePointsByParams(array $params) 消耗积分
 * @method getPointClearedByParams(array $params) 获取用户即将积分清零信息
 * @method clearedPointByMQByParams(array $params) MQ积分清零
 */
class Points {
    private static string $serviceName = "UserMember";

    private static string $className = "Himo\\Points";

    /**
     * 领取积分
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function receivePoints (int $userId, int $outId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receivePoints(array_merge($_params, ["userId" => $userId, "outId" => $outId]));
    }

    /**
     * 积分变更查询-分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getPoints (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPoints(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 积分变更查询-不分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 获取用户待清理积分
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCleanablePoints (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCleanablePoints(["userId" => $userId]);
    }

    /**
     * 消耗积分
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function consumePoints (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->consumePoints($_params);
    }

    /**
     * 获取用户即将积分清零信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPointCleared (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPointCleared(["userId" => $userId]);
    }

    /**
     * MQ积分清零
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function clearedPointByMQ (int $outId, int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearedPointByMQ(["outId" => $outId, "userId" => $userId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}