<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-11 11:38:18
 */
namespace Mainto\Bridge\Structs\UserMember\SweetMember\Cmd;

class CreateSweetMemberCmd {
    /**
     * @var  int
     * 会员id
     * validation: gte:1
     */
    public int $userId;
    /**
     * @var  float
     * 总分值
     * validation: 
     */
    public float $integral = 0;
    /**
     * @var  float
     * 基础分值
     * validation: 
     */
    public float $baseIntegral = 0;
    /**
     * @var  string
     * 分值累积截止时间
     * validation: sometimes|date_format:Y-m-d H:i:s
     */
    public string $integralIncrDeadlineAt;
    /**
     * @var  string
     * 状态。opening/opened
     * validation: in:unopened,opening,opened
     */
    public string $status;
    /**
     * @var  string
     * sweet过期时间
     * validation: sometimes|date_format:Y-m-d H:i:s
     */
    public string $expiredAt;
    /**
     * @var  string
     * 纪念日
     * validation: sometimes|date_format:Y-m-d H:i:s
     */
    public string $anniversary;
    /**
     * @var  array
     * 扩展字段
     * validation: 
     */
    public array $extend = [];

    public function __construct (int $userId = 0, string $integralIncrDeadlineAt = '', string $status = '', string $expiredAt = '', string $anniversary = '') {
        if (!is_null($userId)) {
            $this->userId = $userId;
        }
        if (!is_null($integralIncrDeadlineAt)) {
            $this->integralIncrDeadlineAt = $integralIncrDeadlineAt;
        }
        if (!is_null($status)) {
            $this->status = $status;
        }
        if (!is_null($expiredAt)) {
            $this->expiredAt = $expiredAt;
        }
        if (!is_null($anniversary)) {
            $this->anniversary = $anniversary;
        }
    }

    public static function create(int $userId = 0, string $integralIncrDeadlineAt = '', string $status = '', string $expiredAt = '', string $anniversary = ''): self {
        return new self($userId, $integralIncrDeadlineAt, $status, $expiredAt, $anniversary);
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setIntegral(float $integral): self {
        $this->integral = $integral;

        return $this;
    }

    public function setBaseIntegral(float $baseIntegral): self {
        $this->baseIntegral = $baseIntegral;

        return $this;
    }

    public function setIntegralIncrDeadlineAt(string $integralIncrDeadlineAt): self {
        $this->integralIncrDeadlineAt = $integralIncrDeadlineAt;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setExpiredAt(string $expiredAt): self {
        $this->expiredAt = $expiredAt;

        return $this;
    }

    public function setAnniversary(string $anniversary): self {
        $this->anniversary = $anniversary;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }
}