<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-11 11:38:18
 */
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Task
 * @method memberReviewByParams(array $params) 会员年审-每隔十分钟执行一次
 * @method resetAllMembersExpeditedWelfareByParams(array $params) 重置会员加急次数
 * @method medalVerificationByParams(array $params) 核对勋章
 * @method setPointsClearedLimitByParams(array $params) 控制清零速度
 * @method pointsClearedByParams(array $params) 年度积分清零
 * @method delayPointClearedTimeByParams(array $params) 更改积分清零时间
 * @method setOtherCouponTemplateExpiredByParams(array $params) 定期更改过期三方券码模版状态 -- 每1分钟
 */
class Task {
    private static string $serviceName = "UserMember";

    private static string $className = "Task";

    /**
     * 会员年审-每隔十分钟执行一次
     * @return  mixed
    */
    public static function memberReview () {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberReview();
    }

    /**
     * 重置会员加急次数
     * @return  mixed
    */
    public static function resetAllMembersExpeditedWelfare () {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetAllMembersExpeditedWelfare();
    }

    /**
     * 核对勋章
     * @return  mixed
    */
    public static function medalVerification () {
        return RpcClass::getClass(self::$serviceName, self::$className)->medalVerification();
    }

    /**
     * 控制清零速度
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setPointsClearedLimit (int $limit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPointsClearedLimit(["limit" => $limit]);
    }

    /**
     * 年度积分清零
     * @return  bool
    */
    public static function pointsCleared () {
        return RpcClass::getClass(self::$serviceName, self::$className)->pointsCleared();
    }

    /**
     * 更改积分清零时间
     * @return  bool
    */
    public static function delayPointClearedTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delayPointClearedTime();
    }

    /**
     * 定期更改过期三方券码模版状态 -- 每1分钟
     * @return  bool
    */
    public static function setOtherCouponTemplateExpired () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOtherCouponTemplateExpired();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}