<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-11 11:38:18
 */
namespace Mainto\Bridge\Invokes\UserMember\FamilyMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class FamilyMember
 * @method detailByUserIdByParams(array $params) 获取家庭会员详情
 * @method createFamilyMemberByParams(array $params) 创建学生会员
 * @method updateMemberStatusByParams(array $params) 更新学生会员状态
 * @method batchUpdateMemberStatusByParams(array $params) 批量更新学生会员状态
 * @method getFamilyMembersByParams(array $params) 分页获取家庭会员
 */
class FamilyMember {
    private static string $serviceName = "UserMember";

    private static string $className = "FamilyMember\\FamilyMember";

    /**
     * 获取家庭会员详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberDetailDTO
    */
    public static function detailByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailByUserId(["userId" => $userId]),
            "\Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberDetailDTO"
        );
    }

    /**
     * 创建学生会员
     * @return  int
    */
    public static function createFamilyMember (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\CreateFamilyMemberCMD $createFamilyMemberCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createFamilyMember($createFamilyMemberCMD);
    }

    /**
     * 更新学生会员状态
     * @return  bool
    */
    public static function updateMemberStatus (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\UpdateMemberStatusCMD $updateMemberStatusCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMemberStatus($updateMemberStatusCMD);
    }

    /**
     * 批量更新学生会员状态
     * @return  bool
    */
    public static function batchUpdateMemberStatus (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\BatchUpdateMemberStatusCMD $batchUpdateMemberStatusCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateMemberStatus($batchUpdateMemberStatusCMD);
    }

    /**
     * 分页获取家庭会员
     * @return  \Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberListDTO
    */
    public static function getFamilyMembers (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\FamilyMemberListCMD $familyMemberListCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getFamilyMembers($familyMemberListCMD),
            "\Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}