<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-17 11:41:30
 */
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MemberCardTemplate
 * @method createByParams(array $params) 创建会员卡模板
 * @method updateByParams(array $params) 修改会员卡模板
 * @method getInfoByTemplateIdByParams(array $params) 获取1条会员卡模板
 * @method getMemberCardTemplatesByParams(array $params) 获取会员卡模板分页数据
 * @method modifyStateToUpByParams(array $params) 上架会员卡模板
 * @method modifyStateToDownByParams(array $params) 下架会员卡模板
 * @method listByParams(array $params) 获取会员卡模板列表数据
 */
class MemberCardTemplate {
    private static string $serviceName = "UserMember";

    private static string $className = "MemberCardTemplate";

    /**
     * 创建会员卡模板
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }
    /**
     * 修改会员卡模板
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function update (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($_params);
    }
    /**
     * 获取1条会员卡模板
     * @return  array
    */
    public static function getInfoByTemplateId (int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoByTemplateId(["templateId" => $templateId]);
    }
    /**
     * 获取会员卡模板分页数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMemberCardTemplates (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberCardTemplates($_params);
    }
    /**
     * 上架会员卡模板
     * @return  bool
    */
    public static function modifyStateToUp (int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyStateToUp(["templateId" => $templateId]);
    }
    /**
     * 下架会员卡模板
     * @return  bool
    */
    public static function modifyStateToDown (int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyStateToDown(["templateId" => $templateId]);
    }
    /**
     * 获取会员卡模板列表数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}