<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-17 11:41:30
 */
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MemberCard
 * @method getMemberCardsByParams(array $params) 获取会员卡列表--分页
 * @method detailByParams(array $params) 获取会员卡详情
 * @method bulkOpenByParams(array $params) 会员卡批量开启
 * @method bulkForbiddenByParams(array $params) 会员卡批量禁用
 * @method listByParams(array $params) 获取会员卡列表
 * @method memberStudentIdentityChangeByParams(array $params) 学生会员身份变更
 */
class MemberCard {
    private static string $serviceName = "UserMember";

    private static string $className = "MemberCard";

    /**
     * 获取会员卡列表--分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getMemberCards (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberCards(array_merge($_params, []));
    }
    /**
     * 获取会员卡详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function detail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($_params);
    }
    /**
     * 会员卡批量开启
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function bulkOpen (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkOpen($_params);
    }
    /**
     * 会员卡批量禁用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function bulkForbidden (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkForbidden($_params);
    }
    /**
     * 获取会员卡列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 学生会员身份变更
     * @return  bool
    */
    public static function memberStudentIdentityChange (int $userId, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberStudentIdentityChange(["userId" => $userId, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}