<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-25 09:25:43
 */
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class FixMember
 */
class FixMember {
    private static string $serviceName = "UserMember";

    private static string $className = "FixMember";

    /**
     * 配合订单修复用户流水
     * @return  bool
    */
    public static function attachOrderFlow (int $userId, string $type, string $source, int $orderId, string $createdAt, int $orderDiffId, float $consumeAmount, bool $isNewOrder = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->attachOrderFlow(["userId" => $userId, "type" => $type, "source" => $source, "orderId" => $orderId, "createdAt" => $createdAt, "orderDiffId" => $orderDiffId, "consumeAmount" => $consumeAmount, "isNewOrder" => $isNewOrder]);
    }
    /**
     * 补充记录流水【之前存在消费但是未纪录积分的】
     * @return  bool
    */
    public static function attachPoints (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->attachPoints(["recordId" => $recordId]);
    }
    /**
     * 重算会员积分
     * @return  bool
    */
    public static function resetMember (int $userId, string $dateStart, string $dateEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetMember(["userId" => $userId, "dateStart" => $dateStart, "dateEnd" => $dateEnd]);
    }
    /**
     * 添加会员数据
     * @return  mixed
    */
    public static function fixCreateHimoMember (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixCreateHimoMember($_params);
    }
    /**
     * 修复 kids 和 family 订单流水
     * @return  mixed
    */
    public static function fixCreateKidsAndFamilyOrderFlow (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixCreateKidsAndFamilyOrderFlow($_params);
    }
    /**
     * 异常账户积分清零
     * @return  bool
    */
    public static function fixPointCleared (int $userId, int $userIntegral, string $pointClearedTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixPointCleared(["userId" => $userId, "userIntegral" => $userIntegral, "pointClearedTime" => $pointClearedTime]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}