<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-12 11:42:37
 */
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MemberCardTemplate
 */
class MemberCardTemplate {
    private static string $serviceName = "UserMember";

    private static string $className = "MemberCardTemplate";

    /**
     * 创建会员卡模板
     * @return  bool
    */
    public static function create (string $title, int $createBy, string $cardType, string $identity, int $total, string $pushTime, string $gainType, array $gainConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["title" => $title, "createBy" => $createBy, "cardType" => $cardType, "identity" => $identity, "total" => $total, "pushTime" => $pushTime, "gainType" => $gainType, "gainConfig" => $gainConfig]);
    }
    /**
     * 修改会员卡模板
     * @return  bool
    */
    public static function update (int $templateId, int $createBy, string $title, string $cardType, string $identity, int $total, string $pushTime, string $gainType, array $gainConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["templateId" => $templateId, "createBy" => $createBy, "title" => $title, "cardType" => $cardType, "identity" => $identity, "total" => $total, "pushTime" => $pushTime, "gainType" => $gainType, "gainConfig" => $gainConfig]);
    }
    /**
     * 获取1条会员卡模板
     * @return  array
    */
    public static function getInfoByTemplateId (int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoByTemplateId(["templateId" => $templateId]);
    }
    /**
     * 获取会员卡模板分页数据
     * @return  array
    */
    public static function getMemberCardTemplates (string $type, string $identity, string $state, string $templateName, string $releaseStartTime, string $releaseEndTime, string $createStartTime, string $createEndTime, array $sortBy, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberCardTemplates(["type" => $type, "identity" => $identity, "state" => $state, "templateName" => $templateName, "releaseStartTime" => $releaseStartTime, "releaseEndTime" => $releaseEndTime, "createStartTime" => $createStartTime, "createEndTime" => $createEndTime, "sortBy" => $sortBy, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 上架会员卡模板
     * @return  bool
    */
    public static function modifyStateToUp (int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyStateToUp(["templateId" => $templateId]);
    }
    /**
     * 下架会员卡模板
     * @return  bool
    */
    public static function modifyStateToDown (int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyStateToDown(["templateId" => $templateId]);
    }
    /**
     * 获取会员卡模板列表数据
     * @return  array
    */
    public static function list (array $templateIds, string $type, string $templateName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["templateIds" => $templateIds, "type" => $type, "templateName" => $templateName]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}