<?php
namespace Mainto\Bridge\Invokes\UserMember\FamilyMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByUserIdByParams(array $params)
 * @method createFamilyMemberByParams(array|\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\CreateFamilyMemberCMD $params)
 * @method updateMemberStatusByParams(array|\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\UpdateMemberStatusCMD $params)
 * @method getFamilyMembersByParams(array|\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\FamilyMemberListCMD $params)
 */
class FamilyMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取家庭会员详情
     *
     * @param  int $userId 会员id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberDetailDTO
     */
    public static function detailByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailByUserId([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberDetailDTO"
        );
    }

    /**
     * 创建学生会员
     *
     * @var  \Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\CreateFamilyMemberCMD $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function createFamilyMember (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\CreateFamilyMemberCMD $cmd) {
        return self::getClass()->createFamilyMember($cmd);
    }


    /**
     * 更新学生会员状态
     *
     * @var  \Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\UpdateMemberStatusCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateMemberStatus (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\UpdateMemberStatusCMD $cmd) {
        return self::getClass()->updateMemberStatus($cmd);
    }


    /**
     * 分页获取家庭会员
     *
     * @var  \Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\FamilyMemberListCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberListDTO
     */
    public static function getFamilyMembers (\Mainto\Bridge\Structs\UserMember\FamilyMember\CMD\FamilyMemberListCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getFamilyMembers($cmd),
            "\Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'FamilyMember\FamilyMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'FamilyMember\FamilyMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}