<?php
namespace Mainto\Bridge\Invokes\UserMember\FamilyMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByUserIdByParams(array $params)
 */
class FamilyMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取家庭会员详情
     *
     * @param  int $userId 会员id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberDetailDTO
     */
    public static function detailByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailByUserId([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\UserMember\FamilyMember\DTO\FamilyMemberDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'FamilyMember\FamilyMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'FamilyMember\FamilyMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}