<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStateByParams(array $params)
 * @method getAllMilestonesByParams(array $params)
 * @method infoByParams(array $params)
 */
class Milestone {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建里程碑
     *
     * @support  string $name 名称 [ require true ]
     * @support  int $integral 积分 [ require true ]
     * @support  string $state 里程碑状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新里程碑
     *
     * @param  int $id 里程碑ID [ require true ]
     * @support  string $name 名称 [ require false ]
     * @support  int $integral 积分 [ require false ]
     * @support  string $state 里程碑状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 更新里程碑状态
     *
     * @param  int $id 里程碑ID [ require true ]
     * @param  string $state 里程碑状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (int $id, string $state) {
        return self::getClass()->updateState([
            "id" => $id,
            "state" => $state,
        ]);
    }

    /**
     * 获取所有里程碑
     *
     * @param  string $state 里程碑状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllMilestones (string $state = '') {
        return self::getClass()->getAllMilestones([
            "state" => $state,
        ]);
    }

    /**
     * 里程碑详情
     *
     * @support  int $id 里程碑ID [ require false ]
     * @support  int $integral 里程碑积分 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info () {
        return self::getClass()->info([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\Milestone');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\Milestone');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}